% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olfreg.R
\name{olfreg}
\alias{olfreg}
\title{Functional ordinal logistic regression model}
\usage{
olfreg(formula, betalist = NULL)
}
\arguments{
\item{formula}{a formula expression of the form \code{response ~ predictors}. On the left side of the formula, \code{y} is a factor variable whereas on the right side,
\code{X} can be either functional data object of class \code{fd} or a scalar variable of class \code{numeric}. The length of a scalar variable must equal the length
of a response variable. Similarly, the number of observations of a functional covariate must equal the length of a response variable.}

\item{betalist}{an optional argument. A list which contains beta regression coefficient functions for independent variables.
If betalist is not provided, the number of estimated beta regression coefficient functions for one functional covariate would equal the number of basis functions used to represent that functional covariate.
For a scalar variable, beta regression coefficient function is also a functional object whose basis is constant.
Needless to say, for a scalar variable, there will be one beta regression coefficient.}
}
\value{
\item{call}{ call of the olfreg function}

\item{x.count}{ number of predictors}

\item{xfdlist}{ a list of functional data objects. The length of the list is equal to the number of predictors}

\item{betalist}{ a list of beta regression coefficient functions}

\item{coefficients}{  estimated beta regression coefficient functions}

\item{alpha}{  estimated intercepts which represent boudaries of categories of dependent factor variable \code{y}}

\item{ylev}{ a number of categories of a response variable}

\item{fitted.values}{  fitted probabilities of a dependent factor variable \code{y}}

\item{loglik}{  a value of log-likelihood function at optimum}

\item{grd}{  a vector of gradient values at optimum}

\item{Hess}{  Hessian matrix at optimum}

\item{df}{ degrees of freedom}

\item{AIC}{ Akaike information criterion}

\item{iteration}{  number of iterations of Fisher Scoring algorithm needed for convergence}
}
\description{
Functional ordinal logistic regression model in which the response variable is a factor variable
whereas the independent variables are functional variables. Independent variables could also be scalar variables.
}
\examples{
# cycling dataset
library(fda)
# creation of ordinal variable from HR variable
zoneHR=rep(0,216)
zoneHR[which(rowMeans(cycling$HR[,1:60])<107)]=1
zoneHR[which((rowMeans(cycling$HR[,1:60])<125)&(rowMeans(cycling$HR[,1:60])>107))]=2
zoneHR[which((rowMeans(cycling$HR[,1:60])<142)&(rowMeans(cycling$HR[,1:60])>125))]=3
zoneHR[which((rowMeans(cycling$HR[,1:60])<160)&(rowMeans(cycling$HR[,1:60])>142))]=4
zoneHR[which((rowMeans(cycling$HR[,1:60])>160))]=5
# first functional variable - power (WATTS)
watts = t(cycling$WATTS[,1:60])
# set up a fourier basis system due to its cycling pattern
xbasis = create.fourier.basis(c(1,60),5) # 5 basis functions for example
watts.fd = smooth.basis(c(1:60),watts,xbasis)$fd
zoneHR = as.factor(zoneHR)
formula = zoneHR ~ watts.fd
olfreg.model = olfreg(formula = formula)
# additional functional variable - cadence (CAD)
cad = t(cycling$CAD[,1:60])
# set up a functional variable for cad
xbasis2 = create.bspline.basis(c(1,60), nbasis = 5, norder = 4)
cad.fd = smooth.basis(c(1:60),cad,xbasis2)$fd
formula = zoneHR ~ watts.fd + cad.fd
olfreg.model = olfreg(formula = formula)
}
