% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Depca.R
\name{Depca}
\alias{Depca}
\title{Decentralized PCA}
\usage{
Depca(data,K, nk, d, eps, nit.max)
}
\arguments{
\item{data}{is  a sparse random projection matrix}

\item{K}{is  the desired target rank.}

\item{nk}{is the size of subsets.}

\item{d}{is the dimension.
p the number of variables.}

\item{eps}{the error of the subsets.}

\item{nit.max}{the maximum of the subsets.}
}
\value{
MSEXrp, MSEvrp, MSESrp, kopt
}
\description{
Decentralized PCA
}
\examples{
K=20; nk=50; nr=10; p=8;  n=K*nk;d=5
data=matrix(c(rnorm((n-nr)*p,0,1),rpois(nr*p,100)),ncol=p)
set.seed(1234)
eps=10^(-1);nit.max=1000
Depca(data=data,K=K, nk=nk, d=d, eps=eps,nit.max=nit.max)
TXde=TSde=c(rep(0,5))
for (j in 1:5){
 depca=Depca(data,K, nk,d, eps, nit.max)
 TXde[j]=as.numeric(depca)[1]
 TSde[j]=as.numeric(depca)[2]}
mean(TXde)
mean(TSde)
}
