% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{fill_mask}
\alias{fill_mask}
\alias{fill_mask_check}
\title{Run the fill-mask pipeline and check the raw results.}
\usage{
fill_mask(query, model, targets = NULL, topn = 5, gpu)

fill_mask_check(query, models, targets = NULL, topn = 5, gpu)
}
\arguments{
\item{query}{Query sentence with mask token.}

\item{model, models}{Model name(s).}

\item{targets}{Target words to fill in the mask.
Defaults to \code{NULL} (return the top 5 most likely words).}

\item{topn}{Number of the most likely predictions to return.
Defaults to \code{5}.}

\item{gpu}{Use GPU (3x faster than CPU) to run the fill-mask pipeline?
Defaults to missing value that will \emph{automatically} use available GPU
(if not available, then use CPU).
An NVIDIA GPU device (e.g., GeForce RTX Series) is required to use GPU.
See \href{https://psychbruce.github.io/FMAT/#guidance-for-gpu-acceleration}{Guidance for GPU Acceleration}.

Options passing to the \code{device} parameter in Python:
\itemize{
\item \code{FALSE}: CPU (\code{device = -1}).
\item \code{TRUE}: GPU (\code{device = 0}).
\item Any other value: passing to
\href{https://huggingface.co/docs/transformers/main_classes/pipelines#transformers.pipeline.device}{transformers.pipeline(device=...)}
which defines the device (e.g.,
\code{"cpu"}, \code{"cuda:0"}, or a GPU device id like \code{1})
on which the pipeline will be allocated.
}}
}
\value{
A data.table of raw results.
}
\description{
Normal users should use \code{\link[=FMAT_run]{FMAT_run()}}.
This function is only for technical check.
}
\section{Functions}{
\itemize{
\item \code{fill_mask()}: Check performance of one model.

\item \code{fill_mask_check()}: Check performance of multiple models.

}}
\examples{
\dontrun{
query = "Paris is the [MASK] of France."
models = c("bert-base-uncased", "bert-base-cased")

d.check = fill_mask_check(query, models, topn=2)
}

}
