% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE.R
\name{ATE}
\alias{ATE}
\title{Compute Average Treatment Effect}
\usage{
ATE(FLAME_object)
}
\arguments{
\item{FLAME_object}{object returned by applying the FLAME algorithm
(\code{\link{FLAME_bit}}, \code{\link{FLAME_PostgreSQL}}, or
\code{\link{FLAME_SQLite}})}
}
\value{
average treatment effect (ATE) of the matched subsamples
}
\description{
\code{ATE} computes average treatment effect of the matched subsamples by
a weighted average of the estimated treatment effects in each matched group.
The weight is the number of matched units.
}
\examples{
data(toy_data)
result <- FLAME::FLAME_bit(data = toy_data, holdout = toy_data)
FLAME::ATE(result)
}
