% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spExtractPoly.R
\name{spExtractPoly}
\alias{spExtractPoly}
\title{Spatial - Extracts point attribute values from SpatialPolygons layer(s).}
\usage{
spExtractPoly(
  xyplt,
  xyplt_dsn = NULL,
  xy.uniqueid = "PLT_CN",
  polyvlst,
  polyv_dsn = NULL,
  polyvarlst = NULL,
  polyvarnmlst = NULL,
  keepNA = FALSE,
  showext = FALSE,
  savedata = FALSE,
  exportsp = FALSE,
  exportNA = FALSE,
  spMakeSpatial_opts = NULL,
  savedata_opts = NULL,
  gui = FALSE,
  ncores = NULL
)
}
\arguments{
\item{xyplt}{Data frame object or String. Name of layer with xy coordinates
and unique identifier. Can be layer with xy_dsn, full pathname, including
extension, or file name (with extension) in xy_dsn folder.}

\item{xyplt_dsn}{String. Name of database where xyplt is. The dsn varies by
driver. See gdal OGR vector formats (https://www.gdal.org/ogr_formats.html).}

\item{xy.uniqueid}{String.* Unique identifier of xyplt rows.}

\item{polyvlst}{sf R object or String. Name(s) of polygon layers to extract
values. A spatial polygon object, full path to shapefile, or name of a layer
within a database.}

\item{polyv_dsn}{String. Data source name (dsn) where polyvlst layers are
found (e.g., *.sqlite, *.gdb, folder name). The dsn varies by driver.  See
gdal OGR vector formats (https://www.gdal.org/ogr_formats.html).}

\item{polyvarlst}{String vector or list. The name(s) of variable(s) to
extract from polygon(s). If extracting multiple variables from more than one
polygon, specify names in a list format, corresponding to polyvlst.}

\item{polyvarnmlst}{String vector or list. Output name(s) of variable(s)
extracted from polygon(s). If extracting multiple variables from more than
one polygon, specify names in a list format, corresponding to polyvlst. The
number of names must match the number of variables in polyvarlst.}

\item{keepNA}{Logical. If TRUE, keep NA values.}

\item{showext}{Logical. If TRUE, layer extents are displayed in plot window.}

\item{savedata}{Logical. If TRUE, the input data with extracted values are
saved to outfolder.}

\item{exportsp}{Logical. If TRUE, the extracted point data are exported to
outfolder.}

\item{exportNA}{Logical. If TRUE, NULL values are exported to outfolder.}

\item{spMakeSpatial_opts}{List. See help(spMakeSpatial_options()) for a list
of options. Use to convert X/Y values to simple feature (sf) coordinates.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE. If out_layer = NULL,
default = 'polyext'.}

\item{gui}{Logical. If gui, user is prompted for parameters.}

\item{ncores}{Integer. Number of cores to use for extracting values.}
}
\value{
\item{pltdat}{ SpatialPointsDataFrame object or data frame. Input
point data with extracted raster values appended. For multi-part polygons,
more than 1 row per point may be output. } \item{var.name}{ String vector.
Variable names of extracted variables. }

If savedata=TRUE, outdat data frame is saved to outfolder (Default name:
datext_'date'.csv).  If exportsp=TRUE, the SpatialPointsDataFrame object is
exported to outfolder (Default name: datext_'date'.shp). Variable names are
truncated to 10 characters or less (See note below). Name changes are output
to 'outfn'_newnames_'data'.csv in outfolder.
}
\description{
Extracts values from one or more polygon layers and appends to input
SpatialPoints layer or data frame. Points are reprojected on-the-fly to
projection of SpatialPolygons using PROJ.4 transformation parameters and
sf spTransform function.
}
\details{
*If variable = NULL, then it will prompt user for input.

keepnull\cr If keepnull=FALSE, points are excluded when all extracted
variables from any one SpatialPolygons are NULL, returning the points that
fall within the ' intersecting polygons.
}
\note{
If exportshp=TRUE:\cr The st_write (sf) function is called. The ArcGIS
driver truncates variable names to 10 characters or less. Variable names are
changed before export using an internal function (trunc10shp). If Spatial
object has more than 1 record, it will be returned but not exported.

The spTransform (sf) method is used for on-the-fly map projection
conversion and datum transformation using PROJ.4 arguments. Datum
transformation only occurs if the +datum tag is present in the both the from
and to PROJ.4 strings. The +towgs84 tag is used when no datum transformation
is needed. PROJ.4 transformations assume NAD83 and WGS84 are identical
unless other transformation parameters are specified.  Be aware, providing
inaccurate or incomplete CRS information may lead to erroneous data shifts
when reprojecting. See spTransform help documentation for more details.

Any names in polygon layers that are the same as in xyplt are renamed to
name'_1'.
}
\examples{
# Get point data from WYplt data in FIESTA
WYplt <- FIESTA::WYplt

# Get polygon vector layer from FIESTA external data
WYbhdistfn <- system.file("extdata",
                          "sp_data/WYbighorn_districtbnd.shp",
                          package = "FIESTA")

# Extract points from polygon vector layer
xyext <- spExtractPoly(xyplt = WYplt,
                       polyvlst = WYbhdistfn,
                       xy.uniqueid = "CN",
                       spMakeSpatial_opts = list(xvar = "LON_PUBLIC",
                                                 yvar = "LAT_PUBLIC",
                                                 xy.crs = 4269))
names(xyext)
xyext$outnames
spxyext <- xyext$spxyext
head(spxyext)
NAlst <- xyext$NAlst

# Plot extracted values of national forest district
plot(spxyext["DISTRICTNU"])
}
\author{
Tracey S. Frescino
}
\keyword{data}
