% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spUnionPoly.R
\name{spUnionPoly}
\alias{spUnionPoly}
\title{Spatial - Generate a unioned sf object with polygons and attributes from
two sf polygon objects.}
\usage{
spUnionPoly(
  polyv1,
  polyv1_dsn = NULL,
  polyv2,
  polyv2_dsn = NULL,
  showext = FALSE,
  areacalc = FALSE,
  areavar = "ACRES_GIS",
  exportsp = FALSE,
  savedata_opts = NULL,
  ...
)
}
\arguments{
\item{polyv1}{sf R object or String. Polygon data to union. Can be a spatial
polygon object, full pathname to a shapefile, or name of a layer within a
database.}

\item{polyv1_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of layer to union. The dsn varies by driver. See gdal OGR vector
formats (https://www.gdal.org/ogr_formats.html). Optional if polyv1 is sf
object.}

\item{polyv2}{sf R object or String. Polygon data to union. Can be a spatial
polygon object, full pathname to a shapefile, or name of a layer within a
database.}

\item{polyv2_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of layer to union. The dsn varies by driver. See gdal OGR vector
formats (https://www.gdal.org/ogr_formats.html). Optional if polyv2 is sf
object.}

\item{showext}{Logical. If TRUE, layer extents are displayed in plot window.}

\item{areacalc}{Logical. If TRUE, calculate area of unioned polygons and
append to attribute table (See details).}

\item{areavar}{String. Name of area variable.}

\item{exportsp}{Logical. If TRUE, the spatial unioned object is exported to
outfolder (see spExportSpatial for details).}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when export = TRUE. If out_layer = NULL,
default = 'polyunion'.}

\item{...}{For extendibility.}
}
\value{
sf object of unioned polygon. If polyv1 and polyv2 have different
projections, the projection of returned object will have the same projection
as poly1 (See note about on-the-fly projection conversion).

If exportsp=TRUE, the sf object will be written to outfolder (See note).
}
\description{
Generate a unioned sf object with polygons and attribtutes from two sf
polygon objects.
}
\details{
*If variable = NULL, then it will prompt user for input.

Uses raster function union to merge two polygons and crop, if clip=TRUE.
Generates a new ID for each polygon and appends attributes from both
polygons.

areacalc\cr If areacalc = TRUE and the unioned spatial object is not in a
projected coordinate system (i.e., longlat), the object will be reprojected
to the Albers Equal Area projection before area is calculated.
}
\note{
On-the-fly projection conversion\cr The spTransform (sf) method is used
for on-the-fly map projection conversion and datum transformation using
PROJ.4 arguments. Datum transformation only occurs if the +datum tag is
present in the both the from and to PROJ.4 strings. The +towgs84 tag is used
when no datum transformation is needed. PROJ.4 transformations assume NAD83
and WGS84 are identical unless other transformation parameters are
specified.  Be aware, providing inaccurate or incomplete CRS information may
lead to erroneous data shifts when reprojecting. See spTransform help
documentation for more details.

ESRI Shapefile Driver\cr If exportsp=TRUE:\cr The st_write (sf) function
is called. If out_fmt="shp", the ESRI Shapefile driver truncates variable
names to 10 characters or less. Variable names are changed before export
using an internal function (trunc10shp). If sf object has more than 1
record, it will be returned but not exported.
}
\examples{
\dontrun{
# Set up data from `FIESTA` and `raster`
WYbhfn <- system.file("extdata",
                      "sp_data/WYbighorn_adminbnd.shp",
                      package = "FIESTA")
WYbh <- spImportSpatial(WYbhfn)

# Load in USAco data from geodata package
USAco <- geodata::gadm(country="United States", level=2, path=tempdir())    

# Generate unioned `sf` object
polyUnion <- spUnionPoly(polyv1 = USAco[USAco$NAME_1 == "Wyoming",], 
                         polyv2 = WYbh, 
                         areacalc = TRUE)
                         
# Plot the result
plot(sf::st_geometry(polyUnion))
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
