% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bachelier_price.R
\name{BachelierPrice}
\alias{BachelierPrice}
\title{Calculate Bachelier model option price}
\usage{
BachelierPrice(
  strike = forward,
  spot,
  texp = 1,
  sigma,
  intr = 0,
  divr = 0,
  cp = 1L,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{sigma}{(vector of) volatility}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{cp}{call/put sign. \code{1} for call, \code{-1} for put.}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
option price
}
\description{
Calculate Bachelier model option price
}
\examples{
spot <- 100
strike <- seq(80,125,5)
texp <- 1.2
sigma <- 20
intr <- 0.05
FER::BachelierPrice(strike, spot, texp, sigma, intr=intr)

}
\references{
Choi, J., Kim, K., & Kwak, M. (2009).
  Numerical Approximation of the Implied Volatility Under Arithmetic Brownian
  Motion. Applied Mathematical Finance, 16(3), 261-268.
  \doi{10.1080/13504860802583436}
}
\seealso{
\code{\link{BachelierImpvol}}
}
