% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NodeDis.R
\name{NodeDis}
\alias{NodeDis}
\title{NodeDis}
\usage{
NodeDis(meshP, REM, ForceV, NodeKnownL)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{REM}{Reduced element matrix, returned from function ReducedEM.}

\item{ForceV}{Reduced force vector matrix containing the model load parameters. Returned from function ForceVector.}

\item{NodeKnownL}{data frame with constraint parameters applied to each node in the x and y directions. Formatted for use in reduced element matrix. Generated from ApplyBC function.}
}
\value{
Produces tables with new node coordinates that are produced by the geometry under an applied load.
\item{NodeDis}{Nodal displacement}
\item{GlobalND}{Nodal displacement in the global environment}
}
\description{
Calculates global nodal displacements
}
\examples{
data(triMesh)
data(load)
data(reduc_EM)
data(bound)

meshP = triMesh$MeshPts$p
REM = reduc_EM
ForceV = load
NodeKnownL = bound

displacN = NodeDis(meshP, REM, ForceV, NodeKnownL)

}
