% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmatrix.R
\name{subset_hmatrix}
\alias{subset_hmatrix}
\title{Subsets hmatrix according to an index}
\usage{
subset_hmatrix(x, index, compress = TRUE)
}
\arguments{
\item{x}{hmatix object that should be subsetted}

\item{index}{integer vector with (possibly duplicated) indices
for each curve to select}

\item{compress}{logical, defaults to \code{TRUE}. Only used to force a meaningful
behaviour of \code{applyFolds} with hmatrix objects when using nested resampling.}
}
\description{
Subsets hmatrix according to an index
}
\details{
This methods is primary useful when subsetting repeatedly.
}
\examples{
t1 <- rep((1:5)/2, each = 3)
id1 <- rep(1:3, 5)
x1 <- matrix(1:15, ncol = 5) 
s1 <- (1:5)/2 
hmat <- hmatrix(time = t1, id = id1, x = x1, argvals = s1, timeLab = "t1", 
                argvalsLab = "s1", xLab = "test")

index1 <- c(1, 1, 3)
index2 <- c(2, 3, 3)
resMat <- subset_hmatrix(hmat, index = index1)
try(resMat2 <- subset_hmatrix(resMat, index = index2))
resMat <- subset_hmatrix(hmat, index = index1, compress = FALSE)
try(resMat2 <- subset_hmatrix(resMat, index = index2))

}
