% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.gmjmcmc_parallel}
\alias{predict.gmjmcmc_parallel}
\title{Predict using a gmjmcmc result object from a parallel run.}
\usage{
\method{predict}{gmjmcmc_parallel}(object, x, link = function(x) x, quantiles = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{object}{The model to use.}

\item{x}{The new data to use for the prediction, a matrix where each row is an observation.}

\item{link}{The link function to use}

\item{quantiles}{The quantiles to calculate credible intervals for the posterior moddes (in model space).}

\item{...}{Additional arguments to pass to merge_results.}
}
\value{
A list containing aggregated predictions and per model predictions.
\item{aggr}{Aggregated predictions with mean and quantiles.}
\item{preds}{A list of lists containing individual predictions per model per population in object.}
}
\description{
Predict using a gmjmcmc result object from a parallel run.
}
\examples{
result <- gmjmcmc.parallel(
 runs = 1,
 cores = 1,
 list(populations = "best", complex.measure = 2, tol = 0.0000001),
 matrix(rnorm(600), 100),
 P = 2,
 gaussian.loglik,
 loglik.alpha = gaussian.loglik.alpha,
 c("p0", "exp_dbl")
)
preds <- predict(result$results, matrix(rnorm(600), 100))

}
