% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbms.R
\name{fbms}
\alias{fbms}
\title{Fit a BGNLM  model using Genetically Modified Mode Jumping Markov Chain Monte Carlo (MCMC) sampling.
Or Fit a BGLM model using Modified Mode Jumping Markov Chain Monte Carlo (MCMC) sampling.}
\usage{
fbms(
  formula = NULL,
  family = "gaussian",
  data = NULL,
  transforms = NULL,
  loglik.pi = gaussian.loglik,
  loglik.alpha = gaussian.loglik.alpha,
  P = 10,
  runs = 10,
  cores = 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{formula}{A formula object specifying the model structure. Default is NULL.}

\item{family}{The distribution family of the response variable. Currently supports "gaussian" and "binomial". Default is "gaussian".}

\item{data}{A data frame containing the variables in the model. If NULL, the variables are taken from the environment of the formula. Default is NULL.}

\item{transforms}{A list of transformations for BGNLM model. Default is NULL.}

\item{loglik.pi}{The log-likelihood function for estimating the marginal likelihood and posterior modes (only used if family = "custom")}

\item{loglik.alpha}{The log-likelihood function for the alpha parameter in the model. Default is gaussian.loglik.alpha.}

\item{P}{The number of GMJMCMC generations. Default is 10.}

\item{runs}{The number of parallel chains in case of parallel processing. Default is 2.}

\item{cores}{The number of CPU cores to use for parallel processing. Default is 2.}

\item{verbose}{If TRUE, print detailed progress information during the fitting process. Default is FALSE.}

\item{...}{Additional parameters to be passed to the underlying MCMC fitting functions.}
}
\value{
An object containing the results of the fitted model and MCMC sampling.
}
\description{
This function fits a model using the relevant MCMC sampling. The user can specify the formula,
family, data, transforms, and other parameters to customize the model.
}
\examples{
# Fit a Gaussian multivariate time series model
fbms_result <- fbms(
 X1 ~ .,
 family = "gaussian",
 data = data.frame(matrix(rnorm(600), 100)),
 P = 10,
 runs = 1,
 cores = 1
)
summary(fbms_result)
plot(fbms_result)


}
\seealso{
\code{\link{mjmcmc}}, \code{\link{gmjmcmc}}, \code{\link{gmjmcmc.parallel}}
}
