% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_risk.R
\name{quantile_risk}
\alias{quantile_risk}
\title{Extract Conditional Quantile from Simulated Densities}
\usage{
quantile_risk(density, QTAU = 0.05)
}
\arguments{
\item{density}{An object of class \code{fars_density} returned by \code{density()} or \code{nl_density()}.}

\item{QTAU}{A numeric value between 0 and 1 indicating the quantile to extract (e.g., 0.05 for 5th percentile).}
}
\value{
A numeric vector of conditional quantiles (one observation for each time period).
}
\description{
Computes the conditional quantile (e.g., 5th percentile) from a simulated skew-t distribution,
generated via \code{density()} or \code{nl_density()}. The result corresponds to the
risk measure (e.g., Growth-at-Risk, Inflation-at-Risk, Groth-in-Stress etc.).
}
\examples{
\donttest{
Quantiles <- matrix(rnorm(500), ncol = 5)
fars_density <- density(Quantiles,  levels = c(0.05,0.25,0.50,0.75,0.95),  
est_points = 512, random_samples = 1000)
GaR <- quantile_risk(fars_density, QTAU = 0.05)
}

}
