% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{CSSRad}
\alias{CSSRad}
\title{Clear-Sky Solar Radiation (R_so)}
\usage{
CSSRad(a_s = 0.25, b_s = 0.5, elev = NULL, R_a)
}
\arguments{
\item{a_s}{Optional. A numeric scalar that denotes regression constant, expressing the fraction ofextraterrestrial radiation
reaching the earth on overcast days (n = 0). The default is \code{a_s = 0.25}.}

\item{b_s}{Optional. A numeric scalar that denotes fraction of extraterrestrial radiation reaching the earth on clear days
(\eqn{n = N}). The default is \code{b_s = 0.5}}

\item{elev}{Optional. A numeric scalar that denotes the elevation above the sea level [m].}

\item{R_a}{A numeric scalar that denotes extraterrestrial radiation [\eqn{MJ/(m^2\times day)}]}
}
\value{
The function returns the value of clear-sky solar radiation as a numeric scalar.
}
\description{
\code{CSSRad} returns the value of clear-sky solar radiation.
}
\details{
This is a function to calculate the clear-sky solar radiation. The argument \code{elev} is needed when the calibrated values
   of \code{a_s} and \code{b_s} are not available.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
CSSRad(a_s = 0.27, b_s = 0.48, R_a = 25.1)
CSSRad(elev = 100, R_a = 25.1)

}
\seealso{
\code{\link{ExRad}}.
}
