% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Triangular}
\alias{Triangular}
\alias{dTriangular}
\alias{eTriangular}
\alias{lTriangular}
\alias{pTriangular}
\alias{qTriangular}
\alias{rTriangular}
\title{The Triangular Distribution.}
\usage{
dTriangular(x, a = 0, b = 1, theta = 0.5, params = list(a, b, theta))

pTriangular(q, a = 0, b = 1, theta = 0.5, params = list(a, b, theta))

qTriangular(p, a = 0, b = 1, theta = 0.5, params = list(a, b, theta))

rTriangular(n, a = 0, b = 1, theta = 0.5, params = list(a, b, theta))

eTriangular(X, w, method = "numerical.MLE")

lTriangular(X, w, a = 0, b = 1, theta = 0.5, params = list(a, b, theta),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{a,b}{boundary parameters.}

\item{theta}{shape parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lTriangular gives log likelihood.}

\item{...}{other parameters}
}
\value{
dTriangular gives the density; pTriangular gives the distribution function;
qTriangular gives the quantile function; rTriangular generates random variables;
eTriangular estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Triangular distribution
}
\details{
Triangular Distribution

See \href{../doc/Distributions-Four-Parameter-Beta.html}{Distributions-Four-Parameter-Beta}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
a <- 1
b <- 2
theta <- 0.5
X <- rTriangular(n, a, b, theta)
(est.par <- eTriangular(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dTriangular(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qTriangular((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(a,b), ylim = c(a,b))
abline(0,1)

plot((1:n-0.5)/n, pTriangular(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(a=0, b=1, theta=0.5)
X <- rTriangular(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eTriangular(X,w) # estimated parameters of weighted sample
eTriangular(X) # estimated parameters of unweighted sample

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rTriangular,edist=eTriangular,n = 1000, rep.num = 1e3,
params = list(a=0, b=1, theta=0.5), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rTriangular(1000, a, b, theta)
(est.par <- eTriangular(X))
H <- attributes(eTriangular(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lTriangular(X,param = est.par)
lTriangular(X,param = est.par, logL=FALSE)
sTriangular(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

