% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Normal_trunc_ab}
\alias{Normal_trunc_ab}
\alias{dNormal_trunc_ab}
\alias{eNormal_trunc_ab}
\alias{lNormal_trunc_ab}
\alias{pNormal_trunc_ab}
\alias{qNormal_trunc_ab}
\alias{rNormal_trunc_ab}
\title{The truncated normal distribution.}
\usage{
dNormal_trunc_ab(x, mu = 2, sigma = 3, a = 0, b = 1, params = list(mu,
  sigma, a, b))

pNormal_trunc_ab(q, mu = 2, sigma = 3, a = 0, b = 1, params = list(mu
  = 2, sigma = 5, a = 0, b = 1))

qNormal_trunc_ab(p, mu = 2, sigma = 3, a = 0, b = 1, params = list(mu
  = 2, sigma = 5, a = 0, b = 1))

rNormal_trunc_ab(n, mu = 2, sigma = 3, a = 0, b = 1, params = list(mu,
  sigma, a, b))

eNormal_trunc_ab(X, w, method = "numerical.MLE")

lNormal_trunc_ab(X, w, mu = 2, sigma = 3, a = 0, b = 1,
  params = list(mu, sigma, a, b), logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{mu,sigma}{shape parameters.}

\item{a,b}{boundary parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lNormal_trunc_ab gives log likelihood.}

\item{...}{other parameters}
}
\value{
dNormal_trunc_ab gives the density; pNormal_trunc_ab gives the distribution function;
qNormal_trunc_ab gives the quantile function; rNormal_trunc_ab generates random variables;
eNormal_trunc_ab estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the truncated normal distribution
}
\details{
truncated normal Distribution

See \href{../doc/Distributions-Truncted-Normal.html}{Distributions-Truncted-Normal}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
a <- 1
b <- 2
mu <- 2
sigma <- 5
X <- rNormal_trunc_ab(n, mu, sigma, a, b)
(est.par <- eNormal_trunc_ab(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dNormal_trunc_ab(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qNormal_trunc_ab((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(a,b), ylim = c(a,b))
abline(0,1)

plot((1:n-0.5)/n, pNormal_trunc_ab(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(mu=2, sigma=5, a= 1, b=2)
X <- rNormal_trunc_ab(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eNormal_trunc_ab(X,w) # estimated parameters of weighted sample
eNormal_trunc_ab(X) # estimated parameters of unweighted sample

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rNormal_trunc_ab,edist=eNormal_trunc_ab,n = 1000, rep.num = 1e3,
params = list(mu=2, sigma=5, a=0, b=1), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rNormal_trunc_ab(1000, mu, sigma, a, b)
(est.par <- eNormal_trunc_ab(X))
H <- attributes(eNormal_trunc_ab(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lNormal_trunc_ab(X,param = est.par)
lNormal_trunc_ab(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

