% Generated by roxygen2 (4.0.2): do not edit by hand
\name{JohnsonSU}
\alias{JohnsonSU}
\alias{dJohnsonSU}
\alias{eJohnsonSU}
\alias{lJohnsonSU}
\alias{pJohnsonSU}
\alias{qJohnsonSU}
\alias{rJohnsonSU}
\title{The Johnson SU Distribution.}
\usage{
dJohnsonSU(x, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

pJohnsonSU(q, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

qJohnsonSU(p, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

rJohnsonSU(n, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2))

eJohnsonSU(X, w, method = "numerical.MLE")

lJohnsonSU(X, w, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{gamma,delta}{shape parameters.}

\item{xi,lambda}{location-scale parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lJohnsonSU gives log likelihood.}

\item{...}{other parameters}
}
\value{
dJohnsonSU gives the density; pJohnsonSU gives the distribution function;
qJohnsonSU gives the quantile function; rJohnsonSU generates random variables;
eJohnsonSU estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the 4 Parameter beta distribution
}
\details{
Johnson SU Distribution

See \href{../doc/Distributions-Johnson-SU.html}{Distributions-Johnson-SU}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
gamma = -0.5; delta = 2; xi = -0.5; lambda = 2
X <- rJohnsonSU(n, gamma, delta, xi, lambda)
(est.par <- eJohnsonSU(X))
# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dJohnsonSU(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qJohnsonSU((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(-5,5), ylim = c(-5,5))
abline(0,1)

plot((1:n-0.5)/n, pJohnsonSU(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2)
X <- rJohnsonSU(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eJohnsonSU(X,w) # estimated parameters of weighted sample
eJohnsonSU(X) # estimated parameters of unweighted sample

# Extracting shape parameters
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rJohnsonSU,edist=eJohnsonSU,n = 1000, rep.num = 1e3,
params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rJohnsonSU(1000, gamma, delta, xi, lambda)
(est.par <- eJohnsonSU(X))
H <- attributes(eJohnsonSU(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lJohnsonSU(X,param = est.par)
lJohnsonSU(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

