% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dilate_image.R
\name{dilate_image}
\alias{dilate_image}
\title{Funcao para acrescentar bordas nos objetos.}
\usage{
dilate_image(im,n=1,plot=TRUE)
}
\arguments{
\item{im}{Este objeto deve conter uma imagem binaria em uma matriz.}

\item{n}{Numero de vezes que deseja-se a aumentar as bordas.}

\item{plot}{Indica se sera apresentada (TRUE) ou nao (FALSE) (default) a
imagem segmentada.}
}
\value{
Retorna uma imagem acrescentando-se bordas.
}
\description{
Esta funcao permite acrescentar as bordas em objetos nas imagens.
}
\examples{
#Abrindo uma imagem de exemplo
im=read_image(example_image(10),plot=TRUE)
b=gray_scale(im,method = "b",plot=TRUE)
raiz=segmentation(b,threshold = 0.7,selectHigher = TRUE,plot=TRUE)
raiz2=dilate_image(raiz,n = 4,plot = TRUE)
raiz3=dilate_image(raiz,n = 8,plot = TRUE)


}
\seealso{
\code{\link{edit_image}} ,  \code{\link{erode_image}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
