% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normatiza.R
\name{Normatiza}
\alias{Normatiza}
\title{Normatiza a matriz para que os valores variem entre valores pre-estabelecidos.}
\usage{
Normatiza(DadosEntrada, DadosBase=NULL, LimiteInferior=0, LimiteSuperior=1,Metodo=1)
}
\arguments{
\item{DadosEntrada}{Matriz contendo os dados sendo normatizados.}

\item{DadosBase}{Matriz contendo o conjunto de dados referencia para a normatizacao.
Se for "NULL" essa matriz de referencia sera a propria matriz de entrada.}

\item{LimiteInferior}{Numero cujo menor valor devera corresponder.}

\item{LimiteSuperior}{Numero cujo maior valor devera corresponder.}

\item{Metodo}{indica a forma que a normatizacao sera feita. Pode receber o valor
1 ou 2:
\itemize{
 \item  1 = A normatizacao sera feita considerando os dados de cada coluna individualmente.
 \item  2 = A normatizacao sera feita considerando os dados de toda a matriz simultaneamente.
 }}
}
\value{
Retorna a matriz normatizada.
}
\description{
Esta funcao faz a padronizacao da matriz a fim de retirar a escala.
Para isso, os valores das matrizes sao calculados a fim de variar entre um
"LimiteInferior" e um "LimiteSuperior".
}
\examples{
end=example_image(2)
ima=read_image(end,plot=TRUE)
VARI=gray_scale(ima,method = "VARI",plot=TRUE)
VARIb=VARI*2-1
min(VARIb)
max(VARIb)

VARI2=Normatiza(VARIb,LimiteInferior=0, LimiteSuperior=1,Metodo=2)
min(VARI2)
max(VARI2)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
/code{/link{gray_scale}/}
}
