% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gray_scale.R
\name{gray_scale}
\alias{gray_scale}
\title{Function to get a grayscale image from a color image (Funcao para a obtencao
de uma imagem em escala de cinza a partir de uma imagem colorida)}
\usage{
gray_scale(im,method="r",normalize=TRUE,plot=FALSE)
}
\arguments{
\item{im}{:This object must contain an image in EBImage format (Este
objeto deve conter uma imagem no formato do EBImage).}

\item{method}{: Indicates the method for obtaining the gray scale (Este
objeto indica o metodo para a obtencao da escala de cinza).:\cr
 "r" = extrair a banda de vermelho\cr
 "g" = extrair a banda de verde\cr
  "b" = extrair a banda de azul\cr
 "rg" = considera a media da banda de vermelho e verde: (r+g)/2\cr
 "rb" = considera a media da banda de vermelho e azul: (r+b)/2\cr
 "gb" = considera a media da banda de verde e azul: (g+b)/2\cr
"rgb" = considera a media das 3 bandas: (r+g+b)/3\cr
"r/g"=r/g\cr
"r/b"=r/b\cr
"g/r"=g/r\cr
"g/b"=g/b\cr
"b/r"=b/r\cr
"b/g"=b/g\cr
"S"=((R+G+B)-3*B)/(R+G+B)
 "BI"=sqrt((r^2+g^2+b^2)/3)\cr
 "BIM"=sqrt((2r+2g+2b)/3)\cr
 "SCI"=(r-g)/(r+g)\cr
 "GLI"=(2g-r-b)/(2g+r+b)\cr
 "HI"=(2r-g-b)/(g-b)\cr
 "NGRDI"=(g-r)/(g+r)\cr
 "SI"=(r-b)/(r+b)\cr
 "VARI"=(g-r)/(g+r-b)\cr
 "HUE"=atan(2(b-g-r)/30.5(g-r))\cr
 "MGVRI"=(g^2-r^2)/(g^2+r^2)\cr
 "GLI"=(2g-r-b)/(2g+r+b)\cr
 "MPRI"=(g-r)/(g+r)\cr
 "RGVBI"=(g-(br))/(g^2(br))\cr
 "ExG"=(2*g-r-b)\cr
 "VEG"=(g/(g^0.66667*b^0.66667))\cr}

\item{normalize}{Logic value, if true, the pixel values will be corrected to vary between 0 and 1
(Valor logico, se for verdadeiro os valores dos pixels sera corrigido para variar entre 0 e 1).}

\item{plot}{:This object must contain an image in EBImage format (Indica
se sera apresentada (TRUE) ou nao (FALSE) (default) a imagem segmentada).}
}
\value{
Returns an image with text over each object in the image (Retorna uma
  imagem com um texto sobreposto a cada objeto na imagem)
}
\description{
Function to get a grayscale image from a color image (Esta
  funcao permite a obtencao de uma imagem em escala de cinza a partir de uma
  imagem colorida).
}
\examples{
\donttest{
#Carregar imagem de exemplo
im=read_image(example_image(2))
##mostrar imagem
plot_image(im)


#Extraindo as camadas R, G e B
r=gray_scale(im,method = "r",plot=TRUE)
g=gray_scale(im,method = "g",plot=TRUE)
b=gray_scale(im,method = "b",plot=TRUE)
}
}
\seealso{
\code{\link{segmentation_logit}}
}
