% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levene.r
\name{levene}
\alias{levene}
\title{Teste de homogeneidade de variancias de Levene}
\usage{
levene(trat, resp, t, r)
}
\arguments{
\item{trat}{Vetor numerico ou complexo contendo os
tratamentos.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{t}{Escalar. Numero de tratamentos.}

\item{r}{Vetor numerico ou complexo contendo o numero de
repeticoes de cada tratamento.}
}
\value{
Retorna o valor-p do teste de homogeneidade de
variancias de Levene para uma hipotese nula de que as
variancias sao homogeneas.
}
\description{
\code{levene} Executa o teste de homogeneidade de variancias
de Levene (1960) para um delineamento inteiramente
casualizado.
}
\examples{
data(ex1)
attach(ex1)
dic(trat, ig, quali = FALSE, hvar = "levene")
}
\references{
LEVENE, H. Robust tests for equality of
variances. In: Olkin, I.; Ghurye, S.G.; Hoeffding, W.;
Madow, W.G.; Mann, H.B. (eds.). \emph{Contribution to
Probability and Statistics. Stanford}, CA: Stanford
University Press, pages 278-292, 1960.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de variancias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{bartlett}}, \code{\link{samiuddin}},
\code{\link{layard}}, \code{\link{oneillmathews}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Marcos Costa de Paula
 @author Mateus Pimenta Siqueira Lima
}
