% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_by_group_trend_graph.R
\name{prepare_by_group_trend_graph}
\alias{prepare_by_group_trend_graph}
\title{Prepares a By Group Trend Graph}
\usage{
prepare_by_group_trend_graph(
  df,
  ts_id,
  group_var,
  var,
  points = TRUE,
  error_bars = FALSE
)
}
\arguments{
\item{df}{Data frame containing the ordered factor and a set of numerical variables
to be plotted.}

\item{ts_id}{a string containing the column name of the ordered factor
(normally the time-series indicator).}

\item{group_var}{a variable coercible into a factor to group the data on.}

\item{var}{The name of the variable that you want to plot.}

\item{points}{Do you want points to indicate the observations? Defaults to \code{TRUE}.}

\item{error_bars}{Do you want error bars to be plotted? Defaults to \code{FALSE}.}
}
\value{
A list containing two items:
\describe{
 \item{"df"}{A data frame containing the plotted means and standard errors by group}
 \item{"plot}{The plot as returned by \code{ggplot}}
}
}
\description{
Reads a data frame and line plots the selected variables (which need to be numeric)
 by group and an ordered factor (normally the time-series indicator).
}
\examples{
df <- worldbank
df$gdp_capita <- worldbank$NY.GDP.PCAP.KD
graph <- prepare_by_group_trend_graph(df, "year", "region", "gdp_capita")
graph$plot
}
