% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.evaluate.core.R
\name{coverage.evaluate.core}
\alias{coverage.evaluate.core}
\title{Class Coverage}
\usage{
coverage.evaluate.core(data, names, qualitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
The Class Coverage value.
}
\description{
Compute the Class Coverage \insertCite{kim_powercore_2007}{EvaluateCore} to
compare the distribution frequencies of qualitative traits between entire
collection (EC) and core set (CS). \loadmathjax
}
\details{
Class Coverage \insertCite{kim_powercore_2007}{EvaluateCore} is computed as
follows.

\mjsdeqn{Class\, Coverage = \left ( \frac{1}{n} \sum_{i=1}^{n}
\frac{A_{CS_{i}}}{A_{EC_{i}}} \right ) \times 100}

Where, \mjseqn{A_{CS_{i}}} is the sets of categories in the CS for the
\mjseqn{i}th trait, \mjseqn{A_{EC_{i}}} is the sets of categories in the EC
for the \mjseqn{i}th trait and \mjseqn{n} is the total number of traits.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

coverage.evaluate.core(data = ec, names = "genotypes",
                       qualitative = qual, selected = core)

}
\references{
\insertAllCited{}
}
