% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{getEunomiaConnectionDetails}
\alias{getEunomiaConnectionDetails}
\title{Get Eunomia Connection Details}
\usage{
getEunomiaConnectionDetails(databaseFile = tempfile(fileext = ".sqlite"))
}
\arguments{
\item{databaseFile}{The path where the database file will be copied to. By default, the database
will be copied to a temporary folder, and will be deleted at the end of the R
session.}
}
\value{
A ConnectionDetails object, to be used with the \code{DatabaseConnector} package.
}
\description{
Creates a copy of the Eunomia database, and provides details for connecting to that copy.
}
\examples{
connectionDetails <- getEunomiaConnectionDetails()
connection <- connect(connectionDetails)
querySql(connection, "SELECT COUNT(*) FROM person;")
disconnect(connection)

}
