% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indqi.R
\name{is_ptnerg}
\alias{is_ptnerg}
\title{Selection index for protein and grain yield}
\usage{
is_ptnerg(GEN, PTN, RG, verbose = TRUE)
}
\arguments{
\item{GEN}{The column with the name of the genotype}

\item{PTN}{The column with the crude protein values}

\item{RG}{The column with the grain yield values (in kg per ha)}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Returns an industrial wheat quality index based solely on protein and
grain yield.
}
\description{
Selection index for protein and grain yield (Pelegrin et al., 2017).
}
\examples{
library(EstimateBreed)

Gen <- c("G1", "G2", "G3", "G4", "G5")
PTN <- c(12.5, 14.2, 13.0, 11.8, 15.1)
RG <- c(3500, 4000, 3700, 3300, 4100)

data <- data.frame(Gen,PTN,RG)

iqptn <- with(data,is_ptnerg(Gen,PTN,RG))
}
\references{
de Pelegrin, A. J., Carvalho, I. R., Nunes, A. C. P., Demari, G. H., Szareski,
V. J., Barbosa, M. H., ... & da Maia, L. C. (2017).
Adaptability, stability and multivariate selection by mixed models.
American Journal of Plant Sciences, 8(13), 3324.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
