% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{+.dist_spec}
\alias{+.dist_spec}
\title{Creates a delay distribution as the sum of two other delay distributions.}
\usage{
\method{+}{dist_spec}(e1, e2)
}
\arguments{
\item{e1}{The first delay distribution (of type <dist_spec>) to
combine.}

\item{e2}{The second delay distribution (of type <dist_spec>) to
combine.}
}
\value{
A delay distribution representing the sum of the two delays
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
# A fixed lognormal distribution with mean 5 and sd 1.
dist1 <- LogNormal(
  meanlog = 1.6, sdlog = 1, max = 20
)
dist1 + dist1

# An uncertain gamma distribution with shape and rate normally distributed
# as Normal(3, 0.5) and Normal(2, 0.5) respectively
dist2 <- Gamma(
  shape = Normal(3, 0.5),
  rate = Normal(2, 0.5),
  max = 20
)
dist1 + dist2
}
