% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_samples}
\alias{extract_samples}
\title{Extract all samples from a stan fit}
\usage{
extract_samples(stan_fit, pars = NULL, include = TRUE)
}
\arguments{
\item{stan_fit}{A \verb{<stanfit>} or \verb{<CmdStanMCMC>} object as returned by
\code{\link[=fit_model]{fit_model()}}.}

\item{pars}{Any selection of parameters to extract}

\item{include}{whether the parameters specified in \code{pars} should be included
(\code{TRUE}, the default) or excluded (\code{FALSE})}
}
\value{
List of data.tables with samples
}
\description{
If the \code{object} argument is a \verb{<stanfit>} object, it simply returns the
result of \code{\link[rstan:stanfit-method-extract]{rstan::extract()}}. If it is a \verb{<CmdStanMCMC>} it returns samples
in the same format as \code{\link[rstan:stanfit-method-extract]{rstan::extract()}} does for \verb{<stanfit>} objects.
}
