% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{c.dist_spec}
\alias{c.dist_spec}
\title{Combines multiple delay distributions for further processing}
\usage{
\method{c}{dist_spec}(...)
}
\arguments{
\item{...}{The delay distributions (from calls to \code{\link[=dist_spec]{dist_spec()}}) to combine}
}
\value{
Combined delay distributions (with class \verb{<dist_spec>})
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This combines the parameters so that they can be fed as multiple delay
distributions to \code{\link[=epinow]{epinow()}} or \code{\link[=estimate_infections]{estimate_infections()}}.
}
\examples{
# A fixed lognormal distribution with mean 5 and sd 1.
dist1 <- LogNormal(
  meanlog = 1.6, sdlog = 1, max = 20
)
dist1 + dist1

# An uncertain gamma distribution with mean 3 and sd 2
dist2 <- Gamma(
  mean = Normal(3, 0.5), sd = Normal(2, 0.5), max = 20
)
c(dist1, dist2)
}
