% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan.R
\name{epinow2_cmdstan_model}
\alias{epinow2_cmdstan_model}
\title{Load and compile an EpiNow2 cmdstanr model}
\usage{
epinow2_cmdstan_model(
  model = "estimate_infections",
  dir = system.file("stan", package = "EpiNow2"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{A character string indicating the model to use. Needs to be
present in \code{dir} (with extension \code{.stan}). Defaults to "estimate_infections".}

\item{dir}{A character string specifying the path to any stan
files to include in the model. If missing the package default is used.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose
messages be shown.}

\item{...}{Additional arguments passed to \code{\link[cmdstanr:cmdstan_model]{cmdstanr::cmdstan_model()}}.}
}
\value{
A \code{cmdstanr} model.
}
\description{
The function has been adapted from a similar function in the epinowcast
package (Copyright holder: epinowcast authors, under MIT License).
}
\keyword{internal}
