% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{estimate_delay}
\alias{estimate_delay}
\title{Estimate a Delay Distribution}
\usage{
estimate_delay(delays, ...)
}
\arguments{
\item{delays}{Integer vector of delays}

\item{...}{Arguments to pass to internal methods.}
}
\value{
A \code{dist_spec} summarising the bootstrapped distribution
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Estimate a log normal delay distribution from a vector of integer delays.
Currently this function is a simple wrapper for \code{bootstrapped_dist_fit}.
}
\examples{
\donttest{
delays <- rlnorm(500, log(5), 1)
estimate_delay(delays, samples = 1000, bootstraps = 10)
}
}
\seealso{
bootstrapped_dist_fit
}
\author{
Sam Abbott
}
