% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_gp_data}
\alias{create_gp_data}
\title{Create Gaussian Process Data}
\usage{
create_gp_data(gp = gp_opts(), data)
}
\arguments{
\item{gp}{A list of options as generated by \code{gp_opts()} to define the
Gaussian process. Defaults to \code{gp_opts()}.Set to NULL to disable the
Gaussian process.}

\item{data}{A list containing the following numeric values: \code{t}, \code{seeding_time},
\code{horizon}.}
}
\value{
A list of settings defining the Gaussian process
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Takes the output of \code{gp_opts()} and converts it into a list understood by \code{stan}.
}
\examples{
# define input data required
data <- list(
  t = 30,
  seeding_time = 7,
  horizon = 7
)

# default gaussian process data
create_gp_data(data = data)

# settings when no gaussian process is desired
create_gp_data(NULL, data)

# custom lengthscale
create_gp_data(gp_opts(ls_mean = 14), data)
}
\seealso{
gp_opts
}
\author{
Sam Abbott
}
