// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_simulate_infections_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_simulate_infections");
    reader.add_event(1, 1, "include", "functions/convolve.stan");
    reader.add_event(1, 0, "start", "functions/convolve.stan");
    reader.add_event(48, 47, "end", "functions/convolve.stan");
    reader.add_event(48, 2, "restart", "model_simulate_infections");
    reader.add_event(48, 2, "include", "functions/pmfs.stan");
    reader.add_event(48, 0, "start", "functions/pmfs.stan");
    reader.add_event(142, 94, "end", "functions/pmfs.stan");
    reader.add_event(142, 3, "restart", "model_simulate_infections");
    reader.add_event(142, 3, "include", "functions/gaussian_process.stan");
    reader.add_event(142, 0, "start", "functions/gaussian_process.stan");
    reader.add_event(222, 80, "end", "functions/gaussian_process.stan");
    reader.add_event(222, 4, "restart", "model_simulate_infections");
    reader.add_event(222, 4, "include", "functions/rt.stan");
    reader.add_event(222, 0, "start", "functions/rt.stan");
    reader.add_event(279, 57, "end", "functions/rt.stan");
    reader.add_event(279, 5, "restart", "model_simulate_infections");
    reader.add_event(279, 5, "include", "functions/infections.stan");
    reader.add_event(279, 0, "start", "functions/infections.stan");
    reader.add_event(360, 81, "end", "functions/infections.stan");
    reader.add_event(360, 6, "restart", "model_simulate_infections");
    reader.add_event(360, 6, "include", "functions/observation_model.stan");
    reader.add_event(360, 0, "start", "functions/observation_model.stan");
    reader.add_event(481, 121, "end", "functions/observation_model.stan");
    reader.add_event(481, 7, "restart", "model_simulate_infections");
    reader.add_event(481, 7, "include", "functions/generated_quantities.stan");
    reader.add_event(481, 0, "start", "functions/generated_quantities.stan");
    reader.add_event(528, 47, "end", "functions/generated_quantities.stan");
    reader.add_event(528, 8, "restart", "model_simulate_infections");
    reader.add_event(537, 17, "include", "data/simulation_rt.stan");
    reader.add_event(537, 0, "start", "data/simulation_rt.stan");
    reader.add_event(545, 8, "end", "data/simulation_rt.stan");
    reader.add_event(545, 18, "restart", "model_simulate_infections");
    reader.add_event(546, 19, "include", "data/simulation_delays.stan");
    reader.add_event(546, 0, "start", "data/simulation_delays.stan");
    reader.add_event(551, 5, "end", "data/simulation_delays.stan");
    reader.add_event(551, 20, "restart", "model_simulate_infections");
    reader.add_event(552, 21, "include", "data/simulation_observation_model.stan");
    reader.add_event(552, 0, "start", "data/simulation_observation_model.stan");
    reader.add_event(559, 7, "end", "data/simulation_observation_model.stan");
    reader.add_event(559, 22, "restart", "model_simulate_infections");
    reader.add_event(611, 72, "end", "model_simulate_infections");
    return reader;
}
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& len, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        int xlen(0);
        (void) xlen;  // dummy to suppress unused var warning
        stan::math::fill(xlen, std::numeric_limits<int>::min());
        stan::math::assign(xlen,num_elements(x));
        current_statement_begin__ = 7;
        int ylen(0);
        (void) ylen;  // dummy to suppress unused var warning
        stan::math::fill(ylen, std::numeric_limits<int>::min());
        stan::math::assign(ylen,num_elements(y));
        current_statement_begin__ = 8;
        validate_non_negative_index("convolution", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> convolution(len);
        stan::math::initialize(convolution, DUMMY_VAR__);
        stan::math::fill(convolution, DUMMY_VAR__);
        stan::math::assign(convolution,rep_vector(0, len));
        current_statement_begin__ = 9;
        for (int i = 1; i <= xlen; ++i) {
            current_statement_begin__ = 10;
            for (int j = 1; j <= std::min(((len - i) + 1), ylen); ++j) {
                current_statement_begin__ = 11;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_uni(((i + j) - 1)), stan::model::nil_index_list()), 
                            (stan::model::rvalue(convolution, stan::model::cons_list(stan::model::index_uni(((i + j) - 1)), stan::model::nil_index_list()), "convolution") + (get_base1(x, i, "x", 1) * get_base1(y, j, "y", 1))), 
                            "assigning variable convolution");
            }
        }
        current_statement_begin__ = 14;
        return stan::math::promote_scalar<fun_return_scalar_t__>(convolution);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& len, std::ostream* pstream__) const {
        return convolve(x, y, len, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_dot_product(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                         const int& len, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 22;
        int ylen(0);
        (void) ylen;  // dummy to suppress unused var warning
        stan::math::fill(ylen, std::numeric_limits<int>::min());
        stan::math::assign(ylen,num_elements(y));
        current_statement_begin__ = 23;
        validate_non_negative_index("z", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z(len);
        stan::math::initialize(z, DUMMY_VAR__);
        stan::math::fill(z, DUMMY_VAR__);
        current_statement_begin__ = 24;
        for (int s = 1; s <= len; ++s) {
            current_statement_begin__ = 25;
            stan::model::assign(z, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        dot_product(stan::model::rvalue(x, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - ylen) + 1)), s), stan::model::nil_index_list()), "x"), tail(y, std::min(ylen, s))), 
                        "assigning variable z");
        }
        current_statement_begin__ = 29;
        return stan::math::promote_scalar<fun_return_scalar_t__>(z);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_dot_product_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                         const int& len, std::ostream* pstream__) const {
        return convolve_dot_product(x, y, len, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_to_report(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& delay_rev_pmf,
                       const int& seeding_time, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(infections));
        current_statement_begin__ = 38;
        validate_non_negative_index("reports", "(t - seeding_time)", (t - seeding_time));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports((t - seeding_time));
        stan::math::initialize(reports, DUMMY_VAR__);
        stan::math::fill(reports, DUMMY_VAR__);
        current_statement_begin__ = 39;
        validate_non_negative_index("unobs_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> unobs_reports(t);
        stan::math::initialize(unobs_reports, DUMMY_VAR__);
        stan::math::fill(unobs_reports, DUMMY_VAR__);
        stan::math::assign(unobs_reports,infections);
        current_statement_begin__ = 40;
        int delays(0);
        (void) delays;  // dummy to suppress unused var warning
        stan::math::fill(delays, std::numeric_limits<int>::min());
        stan::math::assign(delays,num_elements(delay_rev_pmf));
        current_statement_begin__ = 41;
        if (as_bool(delays)) {
            current_statement_begin__ = 42;
            stan::math::assign(unobs_reports, convolve_dot_product(unobs_reports, delay_rev_pmf, t, pstream__));
            current_statement_begin__ = 43;
            stan::math::assign(reports, stan::model::rvalue(unobs_reports, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "unobs_reports"));
        } else {
            current_statement_begin__ = 45;
            stan::math::assign(reports, stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "infections"));
        }
        current_statement_begin__ = 47;
        return stan::math::promote_scalar<fun_return_scalar_t__>(reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_to_report_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& delay_rev_pmf,
                       const int& seeding_time, std::ostream* pstream__) const {
        return convolve_to_report(infections, delay_rev_pmf, seeding_time, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
discretised_pmf(const T0__& mu,
                    const T1__& sigma,
                    const int& n,
                    const int& dist,
                    const int& left_truncate, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 58;
        if (as_bool(logical_gt(sigma, 0))) {
            {
            current_statement_begin__ = 59;
            validate_non_negative_index("upper_cdf", "(n + 1)", (n + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> upper_cdf((n + 1));
            stan::math::initialize(upper_cdf, DUMMY_VAR__);
            stan::math::fill(upper_cdf, DUMMY_VAR__);
            current_statement_begin__ = 60;
            if (as_bool(logical_eq(dist, 0))) {
                current_statement_begin__ = 61;
                for (int i = 1; i <= (n + 1); ++i) {
                    current_statement_begin__ = 62;
                    stan::model::assign(upper_cdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                lognormal_cdf(((i - 1) + left_truncate), mu, sigma), 
                                "assigning variable upper_cdf");
                }
            } else if (as_bool(logical_eq(dist, 1))) {
                {
                current_statement_begin__ = 65;
                local_scalar_t__ alpha(DUMMY_VAR__);
                (void) alpha;  // dummy to suppress unused var warning
                stan::math::initialize(alpha, DUMMY_VAR__);
                stan::math::fill(alpha, DUMMY_VAR__);
                stan::math::assign(alpha,(pow(mu, 2) / pow(sigma, 2)));
                current_statement_begin__ = 66;
                local_scalar_t__ beta(DUMMY_VAR__);
                (void) beta;  // dummy to suppress unused var warning
                stan::math::initialize(beta, DUMMY_VAR__);
                stan::math::fill(beta, DUMMY_VAR__);
                stan::math::assign(beta,(mu / pow(sigma, 2)));
                current_statement_begin__ = 67;
                for (int i = 1; i <= (n + 1); ++i) {
                    current_statement_begin__ = 68;
                    stan::model::assign(upper_cdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                gamma_cdf(((i - 1) + left_truncate), alpha, beta), 
                                "assigning variable upper_cdf");
                }
                }
            } else {
                current_statement_begin__ = 71;
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Unknown distribution function provided.";
                throw std::domain_error(errmsg_stream__.str());
            }
            current_statement_begin__ = 74;
            stan::math::assign(pmf, subtract(stan::model::rvalue(upper_cdf, stan::model::cons_list(stan::model::index_min_max(2, (n + 1)), stan::model::nil_index_list()), "upper_cdf"), stan::model::rvalue(upper_cdf, stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list()), "upper_cdf")));
            current_statement_begin__ = 76;
            stan::math::assign(pmf, divide(pmf, (get_base1(upper_cdf, (n + 1), "upper_cdf", 1) - get_base1(upper_cdf, 1, "upper_cdf", 1))));
            }
        } else {
            current_statement_begin__ = 79;
            stan::math::assign(pmf, rep_vector(0, n));
            current_statement_begin__ = 80;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 82;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_pmf_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& mu,
                    const T1__& sigma,
                    const int& n,
                    const int& dist,
                    const int& left_truncate, std::ostream* pstream__) const {
        return discretised_pmf(mu, sigma, n, dist, left_truncate, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse_mf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 87;
        int max_pmf(0);
        (void) max_pmf;  // dummy to suppress unused var warning
        stan::math::fill(max_pmf, std::numeric_limits<int>::min());
        stan::math::assign(max_pmf,num_elements(pmf));
        current_statement_begin__ = 88;
        validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_pmf(max_pmf);
        stan::math::initialize(rev_pmf, DUMMY_VAR__);
        stan::math::fill(rev_pmf, DUMMY_VAR__);
        current_statement_begin__ = 89;
        for (int d = 1; d <= max_pmf; ++d) {
            current_statement_begin__ = 90;
            stan::model::assign(rev_pmf, 
                        stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                        get_base1(pmf, ((max_pmf - d) + 1), "pmf", 1), 
                        "assigning variable rev_pmf");
        }
        current_statement_begin__ = 92;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev_pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse_mf_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf, std::ostream* pstream__) const {
        return reverse_mf(pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
combine_pmfs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& fixed_pmf,
                 const std::vector<T1__>& pmf_mu,
                 const std::vector<T2__>& pmf_sigma,
                 const std::vector<int>& pmf_n,
                 const std::vector<int>& dist,
                 const int& len,
                 const int& left_truncate,
                 const int& reverse_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 97;
        int n_fixed(0);
        (void) n_fixed;  // dummy to suppress unused var warning
        stan::math::fill(n_fixed, std::numeric_limits<int>::min());
        stan::math::assign(n_fixed,num_elements(fixed_pmf));
        current_statement_begin__ = 98;
        int n_variable(0);
        (void) n_variable;  // dummy to suppress unused var warning
        stan::math::fill(n_variable, std::numeric_limits<int>::min());
        stan::math::assign(n_variable,num_elements(pmf_mu));
        current_statement_begin__ = 99;
        validate_non_negative_index("pmf", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(len);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        stan::math::assign(pmf,rep_vector(0, len));
        current_statement_begin__ = 100;
        if (as_bool(logical_gt(n_fixed, 0))) {
            current_statement_begin__ = 101;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_min_max(1, n_fixed), stan::model::nil_index_list()), 
                        fixed_pmf, 
                        "assigning variable pmf");
        } else if (as_bool(logical_gt(n_variable, 0))) {
            current_statement_begin__ = 103;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 105;
        for (int s = 1; s <= n_variable; ++s) {
            {
            current_statement_begin__ = 106;
            validate_non_negative_index("variable_pmf", "get_base1(pmf_n, s, \"pmf_n\", 1)", get_base1(pmf_n, s, "pmf_n", 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> variable_pmf(get_base1(pmf_n, s, "pmf_n", 1));
            stan::math::initialize(variable_pmf, DUMMY_VAR__);
            stan::math::fill(variable_pmf, DUMMY_VAR__);
            current_statement_begin__ = 107;
            stan::math::assign(variable_pmf, discretised_pmf(get_base1(pmf_mu, s, "pmf_mu", 1), get_base1(pmf_sigma, s, "pmf_sigma", 1), get_base1(pmf_n, s, "pmf_n", 1), get_base1(dist, s, "dist", 1), left_truncate, pstream__));
            current_statement_begin__ = 108;
            stan::math::assign(pmf, convolve(pmf, variable_pmf, len, pstream__));
            }
        }
        current_statement_begin__ = 110;
        if (as_bool(reverse_pmf)) {
            current_statement_begin__ = 111;
            stan::math::assign(pmf, reverse_mf(pmf, pstream__));
        }
        current_statement_begin__ = 113;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct combine_pmfs_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& fixed_pmf,
                 const std::vector<T1__>& pmf_mu,
                 const std::vector<T2__>& pmf_sigma,
                 const std::vector<int>& pmf_n,
                 const std::vector<int>& dist,
                 const int& len,
                 const int& left_truncate,
                 const int& reverse_pmf, std::ostream* pstream__) const {
        return combine_pmfs(fixed_pmf, pmf_mu, pmf_sigma, pmf_n, dist, len, left_truncate, reverse_pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
delays_lp(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const std::vector<int>& delay_dist,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 119;
        int mean_delays(0);
        (void) mean_delays;  // dummy to suppress unused var warning
        stan::math::fill(mean_delays, std::numeric_limits<int>::min());
        stan::math::assign(mean_delays,num_elements(delay_mean));
        current_statement_begin__ = 120;
        int sd_delays(0);
        (void) sd_delays;  // dummy to suppress unused var warning
        stan::math::fill(sd_delays, std::numeric_limits<int>::min());
        stan::math::assign(sd_delays,num_elements(delay_sd));
        current_statement_begin__ = 121;
        if (as_bool(mean_delays)) {
            current_statement_begin__ = 122;
            for (int s = 1; s <= mean_delays; ++s) {
                current_statement_begin__ = 123;
                if (as_bool(logical_gt(get_base1(delay_mean_sd, s, "delay_mean_sd", 1), 0))) {
                    current_statement_begin__ = 125;
                    lp_accum__.add((normal_log(get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1)) * weight));
                    current_statement_begin__ = 127;
                    if (as_bool(get_base1(delay_dist, s, "delay_dist", 1))) {
                        current_statement_begin__ = 128;
                        lp_accum__.add((-(normal_ccdf_log(0, get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1))) * weight));
                    }
                }
            }
        }
        current_statement_begin__ = 133;
        if (as_bool(sd_delays)) {
            current_statement_begin__ = 134;
            for (int s = 1; s <= sd_delays; ++s) {
                current_statement_begin__ = 135;
                if (as_bool(logical_gt(get_base1(delay_sd_sd, s, "delay_sd_sd", 1), 0))) {
                    current_statement_begin__ = 137;
                    lp_accum__.add((normal_log(get_base1(delay_sd, s, "delay_sd", 1), get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1)) * weight));
                    current_statement_begin__ = 138;
                    lp_accum__.add((-(normal_ccdf_log(0, get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1))) * weight));
                }
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct delays_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const std::vector<int>& delay_dist,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return delays_lp(delay_mean, delay_mean_mean, delay_mean_sd, delay_sd, delay_sd_mean, delay_sd_sd, delay_dist, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
lambda(const T0__& L,
           const int& m, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 146;
        local_scalar_t__ lam(DUMMY_VAR__);
        (void) lam;  // dummy to suppress unused var warning
        stan::math::initialize(lam, DUMMY_VAR__);
        stan::math::fill(lam, DUMMY_VAR__);
        current_statement_begin__ = 147;
        stan::math::assign(lam, pow(((m * stan::math::pi()) / (2 * L)), 2));
        current_statement_begin__ = 148;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lam);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct lambda_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& L,
           const int& m, std::ostream* pstream__) const {
        return lambda(L, m, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
phi(const T0__& L,
        const int& m,
        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 153;
        validate_non_negative_index("fi", "rows(x)", rows(x));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> fi(rows(x));
        stan::math::initialize(fi, DUMMY_VAR__);
        stan::math::fill(fi, DUMMY_VAR__);
        current_statement_begin__ = 154;
        stan::math::assign(fi, multiply((1 / stan::math::sqrt(L)), stan::math::sin(multiply(((m * stan::math::pi()) / (2 * L)), add(x, L)))));
        current_statement_begin__ = 155;
        return stan::math::promote_scalar<fun_return_scalar_t__>(fi);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct phi_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& L,
        const int& m,
        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& x, std::ostream* pstream__) const {
        return phi(L, m, x, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
spd_se(const T0__& alpha,
           const T1__& rho,
           const T2__& w, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 159;
        local_scalar_t__ S(DUMMY_VAR__);
        (void) S;  // dummy to suppress unused var warning
        stan::math::initialize(S, DUMMY_VAR__);
        stan::math::fill(S, DUMMY_VAR__);
        current_statement_begin__ = 160;
        stan::math::assign(S, (((pow(alpha, 2) * stan::math::sqrt((2 * stan::math::pi()))) * rho) * stan::math::exp(((-(0.5) * pow(rho, 2)) * pow(w, 2)))));
        current_statement_begin__ = 161;
        return stan::math::promote_scalar<fun_return_scalar_t__>(S);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct spd_se_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& alpha,
           const T1__& rho,
           const T2__& w, std::ostream* pstream__) const {
        return spd_se(alpha, rho, w, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
spd_matern(const T0__& alpha,
               const T1__& rho,
               const T2__& w, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 165;
        local_scalar_t__ S(DUMMY_VAR__);
        (void) S;  // dummy to suppress unused var warning
        stan::math::initialize(S, DUMMY_VAR__);
        stan::math::fill(S, DUMMY_VAR__);
        current_statement_begin__ = 166;
        stan::math::assign(S, ((((4 * pow(alpha, 2)) * pow((stan::math::sqrt(3) / rho), 3)) * 1) / pow((pow((stan::math::sqrt(3) / rho), 2) + pow(w, 2)), 2)));
        current_statement_begin__ = 167;
        return stan::math::promote_scalar<fun_return_scalar_t__>(S);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct spd_matern_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& alpha,
               const T1__& rho,
               const T2__& w, std::ostream* pstream__) const {
        return spd_matern(alpha, rho, w, pstream__);
    }
};
int
setup_noise(const int& ot_h,
                const int& t,
                const int& horizon,
                const int& estimate_r,
                const int& stationary,
                const int& future_fixed,
                const int& fixed_from, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 172;
        int noise_time(0);
        (void) noise_time;  // dummy to suppress unused var warning
        stan::math::fill(noise_time, std::numeric_limits<int>::min());
        stan::math::assign(noise_time,(logical_gt(estimate_r, 0) ? (logical_gt(stationary, 0) ? ot_h : (ot_h - 1) ) : t ));
        current_statement_begin__ = 173;
        int noise_terms(0);
        (void) noise_terms;  // dummy to suppress unused var warning
        stan::math::fill(noise_terms, std::numeric_limits<int>::min());
        stan::math::assign(noise_terms,(logical_gt(future_fixed, 0) ? ((noise_time - horizon) + fixed_from) : noise_time ));
        current_statement_begin__ = 174;
        return stan::math::promote_scalar<fun_return_scalar_t__>(noise_terms);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct setup_noise_functor__ {
            int
    operator()(const int& ot_h,
                const int& t,
                const int& horizon,
                const int& estimate_r,
                const int& stationary,
                const int& future_fixed,
                const int& fixed_from, std::ostream* pstream__) const {
        return setup_noise(ot_h, t, horizon, estimate_r, stationary, future_fixed, fixed_from, pstream__);
    }
};
template <typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
setup_gp(const int& M,
             const T1__& L,
             const int& dimension, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 178;
        validate_non_negative_index("time", "dimension", dimension);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> time(dimension);
        stan::math::initialize(time, DUMMY_VAR__);
        stan::math::fill(time, DUMMY_VAR__);
        current_statement_begin__ = 179;
        validate_non_negative_index("PHI", "dimension", dimension);
        validate_non_negative_index("PHI", "M", M);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> PHI(dimension, M);
        stan::math::initialize(PHI, DUMMY_VAR__);
        stan::math::fill(PHI, DUMMY_VAR__);
        current_statement_begin__ = 180;
        local_scalar_t__ half_dim(DUMMY_VAR__);
        (void) half_dim;  // dummy to suppress unused var warning
        stan::math::initialize(half_dim, DUMMY_VAR__);
        stan::math::fill(half_dim, DUMMY_VAR__);
        stan::math::assign(half_dim,(dimension / 2.0));
        current_statement_begin__ = 181;
        for (int s = 1; s <= dimension; ++s) {
            current_statement_begin__ = 182;
            stan::model::assign(time, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        ((s - half_dim) / half_dim), 
                        "assigning variable time");
        }
        current_statement_begin__ = 184;
        for (int m = 1; m <= M; ++m) {
            current_statement_begin__ = 185;
            stan::model::assign(PHI, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                        phi(L, m, time, pstream__), 
                        "assigning variable PHI");
        }
        current_statement_begin__ = 187;
        return stan::math::promote_scalar<fun_return_scalar_t__>(PHI);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct setup_gp_functor__ {
    template <typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& M,
             const T1__& L,
             const int& dimension, std::ostream* pstream__) const {
        return setup_gp(M, L, dimension, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type, Eigen::Dynamic, 1>
update_gp(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& PHI,
              const int& M,
              const T2__& L,
              const T3__& alpha,
              const T4__& rho,
              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta,
              const int& type, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 192;
        validate_non_negative_index("diagSPD", "M", M);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> diagSPD(M);
        stan::math::initialize(diagSPD, DUMMY_VAR__);
        stan::math::fill(diagSPD, DUMMY_VAR__);
        current_statement_begin__ = 193;
        validate_non_negative_index("SPD_eta", "M", M);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> SPD_eta(M);
        stan::math::initialize(SPD_eta, DUMMY_VAR__);
        stan::math::fill(SPD_eta, DUMMY_VAR__);
        current_statement_begin__ = 194;
        int noise_terms(0);
        (void) noise_terms;  // dummy to suppress unused var warning
        stan::math::fill(noise_terms, std::numeric_limits<int>::min());
        stan::math::assign(noise_terms,rows(PHI));
        current_statement_begin__ = 195;
        validate_non_negative_index("noise", "noise_terms", noise_terms);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> noise(noise_terms);
        stan::math::initialize(noise, DUMMY_VAR__);
        stan::math::fill(noise, DUMMY_VAR__);
        stan::math::assign(noise,rep_vector(1e-6, noise_terms));
        current_statement_begin__ = 196;
        local_scalar_t__ unit_rho(DUMMY_VAR__);
        (void) unit_rho;  // dummy to suppress unused var warning
        stan::math::initialize(unit_rho, DUMMY_VAR__);
        stan::math::fill(unit_rho, DUMMY_VAR__);
        stan::math::assign(unit_rho,(rho / noise_terms));
        current_statement_begin__ = 198;
        if (as_bool(logical_eq(type, 0))) {
            current_statement_begin__ = 199;
            for (int m = 1; m <= M; ++m) {
                current_statement_begin__ = 200;
                stan::model::assign(diagSPD, 
                            stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list()), 
                            stan::math::sqrt(spd_se(alpha, unit_rho, stan::math::sqrt(lambda(L, m, pstream__)), pstream__)), 
                            "assigning variable diagSPD");
            }
        } else if (as_bool(logical_eq(type, 1))) {
            current_statement_begin__ = 203;
            for (int m = 1; m <= M; ++m) {
                current_statement_begin__ = 204;
                stan::model::assign(diagSPD, 
                            stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list()), 
                            stan::math::sqrt(spd_matern(alpha, unit_rho, stan::math::sqrt(lambda(L, m, pstream__)), pstream__)), 
                            "assigning variable diagSPD");
            }
        }
        current_statement_begin__ = 207;
        stan::math::assign(SPD_eta, elt_multiply(diagSPD, eta));
        current_statement_begin__ = 208;
        stan::math::assign(noise, add(noise, multiply(stan::model::rvalue(PHI, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "PHI"), SPD_eta)));
        current_statement_begin__ = 209;
        return stan::math::promote_scalar<fun_return_scalar_t__>(noise);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct update_gp_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& PHI,
              const int& M,
              const T2__& L,
              const T3__& alpha,
              const T4__& rho,
              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta,
              const int& type, std::ostream* pstream__) const {
        return update_gp(PHI, M, L, alpha, rho, eta, type, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
void
gaussian_process_lp(const T0__& rho,
                        const T1__& alpha,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& eta,
                        const T3__& ls_meanlog,
                        const T4__& ls_sdlog,
                        const T5__& ls_min,
                        const T6__& ls_max,
                        const T7__& alpha_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 215;
        if (as_bool(logical_gt(ls_sdlog, 0))) {
            current_statement_begin__ = 216;
            lp_accum__.add(lognormal_log<propto__>(rho, ls_meanlog, ls_sdlog));
            if (rho < ls_min) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else if (rho > ls_max) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-log_diff_exp(lognormal_cdf_log(ls_max, ls_meanlog, ls_sdlog), lognormal_cdf_log(ls_min, ls_meanlog, ls_sdlog)));
        } else {
            current_statement_begin__ = 218;
            lp_accum__.add(inv_gamma_log<propto__>(rho, 1.499007, (0.057277 * ls_max)));
            if (rho < ls_min) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else if (rho > ls_max) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-log_diff_exp(inv_gamma_cdf_log(ls_max, 1.499007, (0.057277 * ls_max)), inv_gamma_cdf_log(ls_min, 1.499007, (0.057277 * ls_max))));
        }
        current_statement_begin__ = 220;
        lp_accum__.add(normal_log<propto__>(alpha, 0, alpha_sd));
        current_statement_begin__ = 221;
        lp_accum__.add(std_normal_log<propto__>(eta));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gaussian_process_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const T0__& rho,
                        const T1__& alpha,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& eta,
                        const T3__& ls_meanlog,
                        const T4__& ls_sdlog,
                        const T5__& ls_min,
                        const T6__& ls_max,
                        const T7__& alpha_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return gaussian_process_lp(rho, alpha, eta, ls_meanlog, ls_sdlog, ls_min, ls_max, alpha_sd, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
update_Rt(const int& t,
              const T1__& log_R,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& noise,
              const std::vector<int>& bps,
              const std::vector<T4__>& bp_effects,
              const int& stationary, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 227;
        int bp_n(0);
        (void) bp_n;  // dummy to suppress unused var warning
        stan::math::fill(bp_n, std::numeric_limits<int>::min());
        stan::math::assign(bp_n,num_elements(bp_effects));
        current_statement_begin__ = 228;
        int bp_c(0);
        (void) bp_c;  // dummy to suppress unused var warning
        stan::math::fill(bp_c, std::numeric_limits<int>::min());
        stan::math::assign(bp_c,0);
        current_statement_begin__ = 229;
        int gp_n(0);
        (void) gp_n;  // dummy to suppress unused var warning
        stan::math::fill(gp_n, std::numeric_limits<int>::min());
        stan::math::assign(gp_n,num_elements(noise));
        current_statement_begin__ = 231;
        validate_non_negative_index("bp", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> bp(t);
        stan::math::initialize(bp, DUMMY_VAR__);
        stan::math::fill(bp, DUMMY_VAR__);
        stan::math::assign(bp,rep_vector(0, t));
        current_statement_begin__ = 232;
        validate_non_negative_index("gp", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gp(t);
        stan::math::initialize(gp, DUMMY_VAR__);
        stan::math::fill(gp, DUMMY_VAR__);
        stan::math::assign(gp,rep_vector(0, t));
        current_statement_begin__ = 233;
        validate_non_negative_index("R", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R(t);
        stan::math::initialize(R, DUMMY_VAR__);
        stan::math::fill(R, DUMMY_VAR__);
        current_statement_begin__ = 235;
        if (as_bool(bp_n)) {
            current_statement_begin__ = 236;
            for (int s = 1; s <= t; ++s) {
                current_statement_begin__ = 237;
                if (as_bool(get_base1(bps, s, "bps", 1))) {
                    current_statement_begin__ = 238;
                    stan::math::assign(bp_c, (bp_c + get_base1(bps, s, "bps", 1)));
                    current_statement_begin__ = 239;
                    stan::model::assign(bp, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                get_base1(bp_effects, bp_c, "bp_effects", 1), 
                                "assigning variable bp");
                }
            }
            current_statement_begin__ = 242;
            stan::math::assign(bp, cumulative_sum(bp));
        }
        current_statement_begin__ = 245;
        if (as_bool(gp_n)) {
            current_statement_begin__ = 246;
            if (as_bool(stationary)) {
                current_statement_begin__ = 247;
                stan::model::assign(gp, 
                            stan::model::cons_list(stan::model::index_min_max(1, gp_n), stan::model::nil_index_list()), 
                            noise, 
                            "assigning variable gp");
                current_statement_begin__ = 249;
                if (as_bool(logical_gt(t, gp_n))) {
                    current_statement_begin__ = 250;
                    stan::model::assign(gp, 
                                stan::model::cons_list(stan::model::index_min_max((gp_n + 1), t), stan::model::nil_index_list()), 
                                rep_vector(get_base1(noise, gp_n, "noise", 1), (t - gp_n)), 
                                "assigning variable gp");
                }
            } else {
                current_statement_begin__ = 253;
                stan::model::assign(gp, 
                            stan::model::cons_list(stan::model::index_min_max(2, (gp_n + 1)), stan::model::nil_index_list()), 
                            noise, 
                            "assigning variable gp");
                current_statement_begin__ = 254;
                stan::math::assign(gp, cumulative_sum(gp));
            }
        }
        current_statement_begin__ = 258;
        stan::math::assign(R, add(add(rep_vector(log_R, t), bp), gp));
        current_statement_begin__ = 259;
        stan::math::assign(R, stan::math::exp(R));
        current_statement_begin__ = 260;
        return stan::math::promote_scalar<fun_return_scalar_t__>(R);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct update_Rt_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const int& t,
              const T1__& log_R,
              const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& noise,
              const std::vector<int>& bps,
              const std::vector<T4__>& bp_effects,
              const int& stationary, std::ostream* pstream__) const {
        return update_Rt(t, log_R, noise, bps, bp_effects, stationary, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T7__, typename T8__, typename T9__, typename T10__, typename T_lp__, typename T_lp_accum__>
void
rt_lp(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& log_R,
          const std::vector<T1__>& initial_infections,
          const std::vector<T2__>& initial_growth,
          const std::vector<T3__>& bp_effects,
          const std::vector<T4__>& bp_sd,
          const int& bp_n,
          const int& seeding_time,
          const T7__& r_logmean,
          const T8__& r_logsd,
          const T9__& prior_infections,
          const T10__& prior_growth, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T_lp__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 268;
        lp_accum__.add(normal_log<propto__>(log_R, r_logmean, r_logsd));
        current_statement_begin__ = 270;
        if (as_bool(logical_gt(bp_n, 0))) {
            current_statement_begin__ = 271;
            lp_accum__.add(normal_log<propto__>(get_base1(bp_sd, 1, "bp_sd", 1), 0, 0.1));
            if (get_base1(bp_sd, 1, "bp_sd", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0, 0.1));
            current_statement_begin__ = 272;
            lp_accum__.add(normal_log<propto__>(bp_effects, 0, get_base1(bp_sd, 1, "bp_sd", 1)));
        }
        current_statement_begin__ = 275;
        lp_accum__.add(normal_log<propto__>(initial_infections, prior_infections, 0.2));
        current_statement_begin__ = 276;
        if (as_bool(logical_gt(seeding_time, 1))) {
            current_statement_begin__ = 277;
            lp_accum__.add(normal_log<propto__>(initial_growth, prior_growth, 0.2));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct rt_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T7__, typename T8__, typename T9__, typename T10__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& log_R,
          const std::vector<T1__>& initial_infections,
          const std::vector<T2__>& initial_growth,
          const std::vector<T3__>& bp_effects,
          const std::vector<T4__>& bp_sd,
          const int& bp_n,
          const int& seeding_time,
          const T7__& r_logmean,
          const T8__& r_logsd,
          const T9__& prior_infections,
          const T10__& prior_growth, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return rt_lp(log_R, initial_infections, initial_growth, bp_effects, bp_sd, bp_n, seeding_time, r_logmean, r_logsd, prior_infections, prior_growth, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__, typename T1__>
typename boost::math::tools::promote_args<T0__, T1__>::type
update_infectiousness(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                          const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gt_rev_pmf,
                          const int& seeding_time,
                          const int& index, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 284;
        int gt_max(0);
        (void) gt_max;  // dummy to suppress unused var warning
        stan::math::fill(gt_max, std::numeric_limits<int>::min());
        stan::math::assign(gt_max,num_elements(gt_rev_pmf));
        current_statement_begin__ = 288;
        int inf_start(0);
        (void) inf_start;  // dummy to suppress unused var warning
        stan::math::fill(inf_start, std::numeric_limits<int>::min());
        stan::math::assign(inf_start,std::max(1, ((index + seeding_time) - gt_max)));
        current_statement_begin__ = 290;
        int inf_end(0);
        (void) inf_end;  // dummy to suppress unused var warning
        stan::math::fill(inf_end, std::numeric_limits<int>::min());
        stan::math::assign(inf_end,((index + seeding_time) - 1));
        current_statement_begin__ = 292;
        int pmf_accessed(0);
        (void) pmf_accessed;  // dummy to suppress unused var warning
        stan::math::fill(pmf_accessed, std::numeric_limits<int>::min());
        stan::math::assign(pmf_accessed,std::min(gt_max, ((index + seeding_time) - 1)));
        current_statement_begin__ = 294;
        local_scalar_t__ new_inf(DUMMY_VAR__);
        (void) new_inf;  // dummy to suppress unused var warning
        stan::math::initialize(new_inf, DUMMY_VAR__);
        stan::math::fill(new_inf, DUMMY_VAR__);
        stan::math::assign(new_inf,dot_product(stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max(inf_start, inf_end), stan::model::nil_index_list()), "infections"), tail(gt_rev_pmf, pmf_accessed)));
        current_statement_begin__ = 297;
        return stan::math::promote_scalar<fun_return_scalar_t__>(new_inf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct update_infectiousness_functor__ {
    template <typename T0__, typename T1__>
        typename boost::math::tools::promote_args<T0__, T1__>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                          const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& gt_rev_pmf,
                          const int& seeding_time,
                          const int& index, std::ostream* pstream__) const {
        return update_infectiousness(infections, gt_rev_pmf, seeding_time, index, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type, Eigen::Dynamic, 1>
generate_infections(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& oR,
                        const int& uot,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gt_rev_pmf,
                        const std::vector<T3__>& initial_infections,
                        const std::vector<T4__>& initial_growth,
                        const int& pop,
                        const int& ht, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 304;
        int ot(0);
        (void) ot;  // dummy to suppress unused var warning
        stan::math::fill(ot, std::numeric_limits<int>::min());
        stan::math::assign(ot,num_elements(oR));
        current_statement_begin__ = 305;
        int nht(0);
        (void) nht;  // dummy to suppress unused var warning
        stan::math::fill(nht, std::numeric_limits<int>::min());
        stan::math::assign(nht,(ot - ht));
        current_statement_begin__ = 306;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,(ot + uot));
        current_statement_begin__ = 307;
        validate_non_negative_index("R", "ot", ot);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R(ot);
        stan::math::initialize(R, DUMMY_VAR__);
        stan::math::fill(R, DUMMY_VAR__);
        stan::math::assign(R,oR);
        current_statement_begin__ = 308;
        local_scalar_t__ exp_adj_Rt(DUMMY_VAR__);
        (void) exp_adj_Rt;  // dummy to suppress unused var warning
        stan::math::initialize(exp_adj_Rt, DUMMY_VAR__);
        stan::math::fill(exp_adj_Rt, DUMMY_VAR__);
        current_statement_begin__ = 309;
        validate_non_negative_index("infections", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infections(t);
        stan::math::initialize(infections, DUMMY_VAR__);
        stan::math::fill(infections, DUMMY_VAR__);
        stan::math::assign(infections,rep_vector(1e-5, t));
        current_statement_begin__ = 310;
        validate_non_negative_index("cum_infections", "ot", ot);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cum_infections(ot);
        stan::math::initialize(cum_infections, DUMMY_VAR__);
        stan::math::fill(cum_infections, DUMMY_VAR__);
        stan::math::assign(cum_infections,rep_vector(0, ot));
        current_statement_begin__ = 311;
        validate_non_negative_index("infectiousness", "ot", ot);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infectiousness(ot);
        stan::math::initialize(infectiousness, DUMMY_VAR__);
        stan::math::fill(infectiousness, DUMMY_VAR__);
        stan::math::assign(infectiousness,rep_vector(1e-5, ot));
        current_statement_begin__ = 313;
        stan::model::assign(infections, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    stan::math::exp(get_base1(initial_infections, 1, "initial_infections", 1)), 
                    "assigning variable infections");
        current_statement_begin__ = 314;
        if (as_bool(logical_gt(uot, 1))) {
            current_statement_begin__ = 315;
            for (int s = 2; s <= uot; ++s) {
                current_statement_begin__ = 316;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            stan::math::exp((get_base1(initial_infections, 1, "initial_infections", 1) + (get_base1(initial_growth, 1, "initial_growth", 1) * (s - 1)))), 
                            "assigning variable infections");
            }
        }
        current_statement_begin__ = 320;
        if (as_bool(pop)) {
            current_statement_begin__ = 321;
            stan::model::assign(cum_infections, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        sum(stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max(1, uot), stan::model::nil_index_list()), "infections")), 
                        "assigning variable cum_infections");
        }
        current_statement_begin__ = 324;
        for (int s = 1; s <= ot; ++s) {
            current_statement_begin__ = 325;
            stan::model::assign(infectiousness, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (stan::model::rvalue(infectiousness, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "infectiousness") + update_infectiousness(infections, gt_rev_pmf, uot, s, pstream__)), 
                        "assigning variable infectiousness");
            current_statement_begin__ = 326;
            if (as_bool((primitive_value(pop) && primitive_value(logical_gt(s, nht))))) {
                current_statement_begin__ = 327;
                stan::math::assign(exp_adj_Rt, stan::math::exp(((-(get_base1(R, s, "R", 1)) * get_base1(infectiousness, s, "infectiousness", 1)) / (pop - get_base1(cum_infections, nht, "cum_infections", 1)))));
                current_statement_begin__ = 328;
                stan::math::assign(exp_adj_Rt, (logical_gt(exp_adj_Rt, 1) ? stan::math::promote_scalar<local_scalar_t__>(1) : stan::math::promote_scalar<local_scalar_t__>(exp_adj_Rt) ));
                current_statement_begin__ = 329;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_uni((s + uot)), stan::model::nil_index_list()), 
                            ((pop - get_base1(cum_infections, s, "cum_infections", 1)) * (1 - exp_adj_Rt)), 
                            "assigning variable infections");
            } else {
                current_statement_begin__ = 331;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_uni((s + uot)), stan::model::nil_index_list()), 
                            (stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_uni((s + uot)), stan::model::nil_index_list()), "infections") + (get_base1(R, s, "R", 1) * get_base1(infectiousness, s, "infectiousness", 1))), 
                            "assigning variable infections");
            }
            current_statement_begin__ = 333;
            if (as_bool((primitive_value(pop) && primitive_value(logical_lt(s, ot))))) {
                current_statement_begin__ = 334;
                stan::model::assign(cum_infections, 
                            stan::model::cons_list(stan::model::index_uni((s + 1)), stan::model::nil_index_list()), 
                            (get_base1(cum_infections, s, "cum_infections", 1) + get_base1(infections, (s + uot), "infections", 1)), 
                            "assigning variable cum_infections");
            }
        }
        current_statement_begin__ = 337;
        return stan::math::promote_scalar<fun_return_scalar_t__>(infections);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct generate_infections_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& oR,
                        const int& uot,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gt_rev_pmf,
                        const std::vector<T3__>& initial_infections,
                        const std::vector<T4__>& initial_growth,
                        const int& pop,
                        const int& ht, std::ostream* pstream__) const {
        return generate_infections(oR, uot, gt_rev_pmf, initial_infections, initial_growth, pop, ht, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
deconvolve_infections(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& shifted_cases,
                          const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& noise,
                          const int& fixed,
                          const int& prior, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 342;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(shifted_cases));
        current_statement_begin__ = 343;
        validate_non_negative_index("infections", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infections(t);
        stan::math::initialize(infections, DUMMY_VAR__);
        stan::math::fill(infections, DUMMY_VAR__);
        stan::math::assign(infections,rep_vector(1e-5, t));
        current_statement_begin__ = 344;
        if (as_bool(logical_negation(fixed))) {
            {
            current_statement_begin__ = 345;
            validate_non_negative_index("exp_noise", "t", t);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> exp_noise(t);
            stan::math::initialize(exp_noise, DUMMY_VAR__);
            stan::math::fill(exp_noise, DUMMY_VAR__);
            stan::math::assign(exp_noise,stan::math::exp(noise));
            current_statement_begin__ = 346;
            if (as_bool(logical_eq(prior, 1))) {
                current_statement_begin__ = 347;
                stan::math::assign(infections, add(infections, elt_multiply(shifted_cases, exp_noise)));
            } else if (as_bool(logical_eq(prior, 0))) {
                current_statement_begin__ = 349;
                stan::math::assign(infections, add(infections, exp_noise));
            } else if (as_bool(logical_eq(prior, 2))) {
                current_statement_begin__ = 351;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (get_base1(infections, 1, "infections", 1) + (get_base1(shifted_cases, 1, "shifted_cases", 1) * get_base1(exp_noise, 1, "exp_noise", 1))), 
                            "assigning variable infections");
                current_statement_begin__ = 352;
                for (int i = 2; i <= t; ++i) {
                    current_statement_begin__ = 353;
                    stan::model::assign(infections, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(infections, (i - 1), "infections", 1) * get_base1(exp_noise, i, "exp_noise", 1)), 
                                "assigning variable infections");
                }
            }
            }
        } else {
            current_statement_begin__ = 357;
            stan::math::assign(infections, add(infections, shifted_cases));
        }
        current_statement_begin__ = 359;
        return stan::math::promote_scalar<fun_return_scalar_t__>(infections);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct deconvolve_infections_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& shifted_cases,
                          const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& noise,
                          const int& fixed,
                          const int& prior, std::ostream* pstream__) const {
        return deconvolve_infections(shifted_cases, noise, fixed, prior, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
day_of_week_effect(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 363;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 364;
        int wl(0);
        (void) wl;  // dummy to suppress unused var warning
        stan::math::fill(wl, std::numeric_limits<int>::min());
        stan::math::assign(wl,num_elements(effect));
        current_statement_begin__ = 366;
        validate_non_negative_index("scaled_effect", "wl", wl);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_effect(wl);
        stan::math::initialize(scaled_effect, DUMMY_VAR__);
        stan::math::fill(scaled_effect, DUMMY_VAR__);
        stan::math::assign(scaled_effect,multiply(wl, effect));
        current_statement_begin__ = 367;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 368;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 370;
            stan::model::assign(scaled_reports, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (get_base1(reports, s, "reports", 1) * get_base1(scaled_effect, get_base1(day_of_week, s, "day_of_week", 1), "scaled_effect", 1)), 
                        "assigning variable scaled_reports");
        }
        current_statement_begin__ = 372;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct day_of_week_effect_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) const {
        return day_of_week_effect(reports, day_of_week, effect, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
scale_obs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 377;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 378;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 379;
        stan::math::assign(scaled_reports, multiply(reports, frac_obs));
        current_statement_begin__ = 380;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct scale_obs_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) const {
        return scale_obs(reports, frac_obs, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
truncate(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& trunc_rev_cmf,
             const int& reconstruct, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 384;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 385;
        validate_non_negative_index("trunc_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_reports(t);
        stan::math::initialize(trunc_reports, DUMMY_VAR__);
        stan::math::fill(trunc_reports, DUMMY_VAR__);
        stan::math::assign(trunc_reports,reports);
        current_statement_begin__ = 387;
        int trunc_max(0);
        (void) trunc_max;  // dummy to suppress unused var warning
        stan::math::fill(trunc_max, std::numeric_limits<int>::min());
        stan::math::assign(trunc_max,num_elements(trunc_rev_cmf));
        current_statement_begin__ = 388;
        int first_t(0);
        (void) first_t;  // dummy to suppress unused var warning
        stan::math::fill(first_t, std::numeric_limits<int>::min());
        stan::math::assign(first_t,((t - trunc_max) + 1));
        current_statement_begin__ = 390;
        if (as_bool(reconstruct)) {
            current_statement_begin__ = 391;
            stan::model::assign(trunc_reports, 
                        stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                        stan::model::deep_copy(elt_divide(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), trunc_rev_cmf)), 
                        "assigning variable trunc_reports");
        } else {
            current_statement_begin__ = 393;
            stan::model::assign(trunc_reports, 
                        stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                        stan::model::deep_copy(elt_multiply(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), trunc_rev_cmf)), 
                        "assigning variable trunc_reports");
        }
        current_statement_begin__ = 395;
        return stan::math::promote_scalar<fun_return_scalar_t__>(trunc_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncate_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& trunc_rev_cmf,
             const int& reconstruct, std::ostream* pstream__) const {
        return truncate(reports, trunc_rev_cmf, reconstruct, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 401;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 402;
        if (as_bool(truncation)) {
            current_statement_begin__ = 403;
            if (as_bool(logical_gt(get_base1(trunc_mean_sd, 1, "trunc_mean_sd", 1), 0))) {
                current_statement_begin__ = 405;
                lp_accum__.add(normal_log<propto__>(truncation_mean, trunc_mean_mean, trunc_mean_sd));
            }
            current_statement_begin__ = 407;
            if (as_bool(logical_gt(get_base1(trunc_sd_sd, 1, "trunc_sd_sd", 1), 0))) {
                current_statement_begin__ = 409;
                lp_accum__.add(normal_log<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return truncation_lp(truncation_mean, truncation_sd, trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const T3__& phi_mean,
              const T4__& phi_sd,
              const int& model_type,
              const T6__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T6__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 417;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 418;
        if (as_bool(model_type)) {
            current_statement_begin__ = 420;
            lp_accum__.add(normal_log<propto__>(get_base1(rep_phi, model_type, "rep_phi", 1), phi_mean, phi_sd));
            if (get_base1(rep_phi, model_type, "rep_phi", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, phi_mean, phi_sd));
            current_statement_begin__ = 421;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 425;
        if (as_bool(logical_gt(sqrt_phi, 1e4))) {
            current_statement_begin__ = 426;
            if (as_bool(logical_eq(weight, 1))) {
                current_statement_begin__ = 427;
                lp_accum__.add(poisson_log<propto__>(cases, reports));
            } else {
                current_statement_begin__ = 429;
                lp_accum__.add((poisson_log(cases, reports) * weight));
            }
        } else {
            current_statement_begin__ = 432;
            if (as_bool(logical_eq(weight, 1))) {
                current_statement_begin__ = 433;
                lp_accum__.add(neg_binomial_2_log<propto__>(cases, reports, sqrt_phi));
            } else {
                current_statement_begin__ = 435;
                lp_accum__.add(neg_binomial_2_log(cases, reports, sqrt_phi));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_lp_functor__ {
    template <typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const T3__& phi_mean,
              const T4__& phi_sd,
              const int& model_type,
              const T6__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return report_lp(cases, reports, rep_phi, phi_mean, phi_sd, model_type, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
report_log_lik(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 443;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 444;
        validate_non_negative_index("log_lik", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(t);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 445;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 446;
        if (as_bool(model_type)) {
            current_statement_begin__ = 448;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 452;
        if (as_bool(logical_gt(sqrt_phi, 1e4))) {
            current_statement_begin__ = 453;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 454;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                            "assigning variable log_lik");
            }
        } else {
            current_statement_begin__ = 457;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 458;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (neg_binomial_2_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1), sqrt_phi) * weight), 
                            "assigning variable log_lik");
            }
        }
        current_statement_begin__ = 461;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_log_lik_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) const {
        return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
    }
};
template <typename T0__, typename T1__, class RNG>
std::vector<int>
report_rng(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 465;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 466;
        validate_non_negative_index("sampled_reports", "t", t);
        std::vector<int  > sampled_reports(t, int(0));
        stan::math::fill(sampled_reports, std::numeric_limits<int>::min());
        current_statement_begin__ = 467;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 468;
        if (as_bool(model_type)) {
            current_statement_begin__ = 469;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 472;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 474;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 475;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            poisson_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), base_rng__), 
                            "assigning variable sampled_reports");
            } else {
                current_statement_begin__ = 477;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            neg_binomial_2_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), sqrt_phi, base_rng__), 
                            "assigning variable sampled_reports");
            }
        }
        current_statement_begin__ = 480;
        return stan::math::promote_scalar<fun_return_scalar_t__>(sampled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_rng_functor__ {
    template <typename T0__, typename T1__, class RNG>
        std::vector<int>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) const {
        return report_rng(reports, rep_phi, model_type, base_rng__, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
calculate_Rt(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                 const int& seeding_time,
                 const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gt_rev_pmf,
                 const int& smooth, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 485;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(infections));
        current_statement_begin__ = 486;
        int ot(0);
        (void) ot;  // dummy to suppress unused var warning
        stan::math::fill(ot, std::numeric_limits<int>::min());
        stan::math::assign(ot,(t - seeding_time));
        current_statement_begin__ = 487;
        validate_non_negative_index("R", "ot", ot);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R(ot);
        stan::math::initialize(R, DUMMY_VAR__);
        stan::math::fill(R, DUMMY_VAR__);
        current_statement_begin__ = 488;
        validate_non_negative_index("sR", "ot", ot);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sR(ot);
        stan::math::initialize(sR, DUMMY_VAR__);
        stan::math::fill(sR, DUMMY_VAR__);
        current_statement_begin__ = 489;
        validate_non_negative_index("infectiousness", "ot", ot);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infectiousness(ot);
        stan::math::initialize(infectiousness, DUMMY_VAR__);
        stan::math::fill(infectiousness, DUMMY_VAR__);
        stan::math::assign(infectiousness,rep_vector(1e-5, ot));
        current_statement_begin__ = 491;
        for (int s = 1; s <= ot; ++s) {
            current_statement_begin__ = 492;
            stan::model::assign(infectiousness, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (stan::model::rvalue(infectiousness, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "infectiousness") + update_infectiousness(infections, gt_rev_pmf, seeding_time, s, pstream__)), 
                        "assigning variable infectiousness");
            current_statement_begin__ = 495;
            stan::model::assign(R, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (get_base1(infections, (s + seeding_time), "infections", 1) / get_base1(infectiousness, s, "infectiousness", 1)), 
                        "assigning variable R");
        }
        current_statement_begin__ = 497;
        if (as_bool(smooth)) {
            current_statement_begin__ = 498;
            for (int s = 1; s <= ot; ++s) {
                {
                current_statement_begin__ = 499;
                local_scalar_t__ window(DUMMY_VAR__);
                (void) window;  // dummy to suppress unused var warning
                stan::math::initialize(window, DUMMY_VAR__);
                stan::math::fill(window, DUMMY_VAR__);
                stan::math::assign(window,0);
                current_statement_begin__ = 500;
                stan::model::assign(sR, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable sR");
                current_statement_begin__ = 501;
                for (int i = std::max(1, (s - smooth)); i <= std::min(ot, (s + smooth)); ++i) {
                    current_statement_begin__ = 502;
                    stan::model::assign(sR, 
                                stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                (stan::model::rvalue(sR, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "sR") + get_base1(R, i, "R", 1)), 
                                "assigning variable sR");
                    current_statement_begin__ = 503;
                    stan::math::assign(window, (window + 1));
                }
                current_statement_begin__ = 505;
                stan::model::assign(sR, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            (get_base1(sR, s, "sR", 1) / window), 
                            "assigning variable sR");
                }
            }
        } else {
            current_statement_begin__ = 508;
            stan::math::assign(sR, R);
        }
        current_statement_begin__ = 510;
        return stan::math::promote_scalar<fun_return_scalar_t__>(sR);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct calculate_Rt_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                 const int& seeding_time,
                 const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& gt_rev_pmf,
                 const int& smooth, std::ostream* pstream__) const {
        return calculate_Rt(infections, seeding_time, gt_rev_pmf, smooth, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type>
R_to_growth(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& R,
                const T1__& gt_mean,
                const T2__& gt_sd, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 514;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(R));
        current_statement_begin__ = 515;
        validate_non_negative_index("r", "t", t);
        std::vector<local_scalar_t__  > r(t, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);
        current_statement_begin__ = 516;
        if (as_bool(logical_gt(gt_sd, 0))) {
            {
            current_statement_begin__ = 517;
            local_scalar_t__ k(DUMMY_VAR__);
            (void) k;  // dummy to suppress unused var warning
            stan::math::initialize(k, DUMMY_VAR__);
            stan::math::fill(k, DUMMY_VAR__);
            stan::math::assign(k,pow((gt_sd / gt_mean), 2));
            current_statement_begin__ = 518;
            for (int s = 1; s <= t; ++s) {
                current_statement_begin__ = 519;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            ((pow(get_base1(R, s, "R", 1), k) - 1) / (k * gt_mean)), 
                            "assigning variable r");
            }
            }
        } else {
            current_statement_begin__ = 523;
            for (int s = 1; s <= t; ++s) {
                current_statement_begin__ = 524;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            (stan::math::log(get_base1(R, s, "R", 1)) / gt_mean), 
                            "assigning variable r");
            }
        }
        current_statement_begin__ = 527;
        return stan::math::promote_scalar<fun_return_scalar_t__>(r);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct R_to_growth_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& R,
                const T1__& gt_mean,
                const T2__& gt_sd, std::ostream* pstream__) const {
        return R_to_growth(R, gt_mean, gt_sd, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_simulate_infections
  : public stan::model::model_base_crtp<model_simulate_infections> {
private:
        int n;
        int t;
        int seeding_time;
        int future_time;
        std::vector<std::vector<double> > initial_infections;
        std::vector<std::vector<double> > initial_growth;
        std::vector<std::vector<double> > gt_mean;
        std::vector<std::vector<double> > gt_sd;
        std::vector<int> gt_max;
        std::vector<int> gt_dist;
        matrix_d R;
        int pop;
        int delays;
        std::vector<std::vector<double> > delay_mean;
        std::vector<std::vector<double> > delay_sd;
        std::vector<int> delay_max;
        std::vector<int> delay_dist;
        std::vector<int> day_of_week;
        int week_effect;
        std::vector<std::vector<double> > day_of_week_simplex;
        int obs_scale;
        std::vector<std::vector<double> > frac_obs;
        int model_type;
        std::vector<std::vector<double> > rep_phi;
        int delay_max_total;
public:
    model_simulate_infections(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_simulate_infections(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_simulate_infections_namespace::model_simulate_infections";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 533;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            current_statement_begin__ = 534;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            current_statement_begin__ = 535;
            context__.validate_dims("data initialization", "seeding_time", "int", context__.to_vec());
            seeding_time = int(0);
            vals_i__ = context__.vals_i("seeding_time");
            pos__ = 0;
            seeding_time = vals_i__[pos__++];
            current_statement_begin__ = 536;
            context__.validate_dims("data initialization", "future_time", "int", context__.to_vec());
            future_time = int(0);
            vals_i__ = context__.vals_i("future_time");
            pos__ = 0;
            future_time = vals_i__[pos__++];
            current_statement_begin__ = 538;
            validate_non_negative_index("initial_infections", "(seeding_time ? n : 0 )", (seeding_time ? n : 0 ));
            validate_non_negative_index("initial_infections", "1", 1);
            context__.validate_dims("data initialization", "initial_infections", "double", context__.to_vec((seeding_time ? n : 0 ),1));
            initial_infections = std::vector<std::vector<double> >((seeding_time ? n : 0 ), std::vector<double>(1, double(0)));
            vals_r__ = context__.vals_r("initial_infections");
            pos__ = 0;
            size_t initial_infections_k_0_max__ = (seeding_time ? n : 0 );
            size_t initial_infections_k_1_max__ = 1;
            for (size_t k_1__ = 0; k_1__ < initial_infections_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < initial_infections_k_0_max__; ++k_0__) {
                    initial_infections[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 539;
            validate_non_negative_index("initial_growth", "(logical_gt(seeding_time, 1) ? n : 0 )", (logical_gt(seeding_time, 1) ? n : 0 ));
            validate_non_negative_index("initial_growth", "1", 1);
            context__.validate_dims("data initialization", "initial_growth", "double", context__.to_vec((logical_gt(seeding_time, 1) ? n : 0 ),1));
            initial_growth = std::vector<std::vector<double> >((logical_gt(seeding_time, 1) ? n : 0 ), std::vector<double>(1, double(0)));
            vals_r__ = context__.vals_r("initial_growth");
            pos__ = 0;
            size_t initial_growth_k_0_max__ = (logical_gt(seeding_time, 1) ? n : 0 );
            size_t initial_growth_k_1_max__ = 1;
            for (size_t k_1__ = 0; k_1__ < initial_growth_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < initial_growth_k_0_max__; ++k_0__) {
                    initial_growth[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 540;
            validate_non_negative_index("gt_mean", "n", n);
            validate_non_negative_index("gt_mean", "1", 1);
            context__.validate_dims("data initialization", "gt_mean", "double", context__.to_vec(n,1));
            gt_mean = std::vector<std::vector<double> >(n, std::vector<double>(1, double(0)));
            vals_r__ = context__.vals_r("gt_mean");
            pos__ = 0;
            size_t gt_mean_k_0_max__ = n;
            size_t gt_mean_k_1_max__ = 1;
            for (size_t k_1__ = 0; k_1__ < gt_mean_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < gt_mean_k_0_max__; ++k_0__) {
                    gt_mean[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t gt_mean_i_0_max__ = n;
            size_t gt_mean_i_1_max__ = 1;
            for (size_t i_0__ = 0; i_0__ < gt_mean_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < gt_mean_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "gt_mean[i_0__][i_1__]", gt_mean[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 541;
            validate_non_negative_index("gt_sd", "n", n);
            validate_non_negative_index("gt_sd", "1", 1);
            context__.validate_dims("data initialization", "gt_sd", "double", context__.to_vec(n,1));
            gt_sd = std::vector<std::vector<double> >(n, std::vector<double>(1, double(0)));
            vals_r__ = context__.vals_r("gt_sd");
            pos__ = 0;
            size_t gt_sd_k_0_max__ = n;
            size_t gt_sd_k_1_max__ = 1;
            for (size_t k_1__ = 0; k_1__ < gt_sd_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < gt_sd_k_0_max__; ++k_0__) {
                    gt_sd[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t gt_sd_i_0_max__ = n;
            size_t gt_sd_i_1_max__ = 1;
            for (size_t i_0__ = 0; i_0__ < gt_sd_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < gt_sd_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "gt_sd[i_0__][i_1__]", gt_sd[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 542;
            validate_non_negative_index("gt_max", "1", 1);
            context__.validate_dims("data initialization", "gt_max", "int", context__.to_vec(1));
            gt_max = std::vector<int>(1, int(0));
            vals_i__ = context__.vals_i("gt_max");
            pos__ = 0;
            size_t gt_max_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < gt_max_k_0_max__; ++k_0__) {
                gt_max[k_0__] = vals_i__[pos__++];
            }
            size_t gt_max_i_0_max__ = 1;
            for (size_t i_0__ = 0; i_0__ < gt_max_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "gt_max[i_0__]", gt_max[i_0__], 1);
            }
            current_statement_begin__ = 543;
            validate_non_negative_index("gt_dist", "1", 1);
            context__.validate_dims("data initialization", "gt_dist", "int", context__.to_vec(1));
            gt_dist = std::vector<int>(1, int(0));
            vals_i__ = context__.vals_i("gt_dist");
            pos__ = 0;
            size_t gt_dist_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < gt_dist_k_0_max__; ++k_0__) {
                gt_dist[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 544;
            validate_non_negative_index("R", "n", n);
            validate_non_negative_index("R", "(t - seeding_time)", (t - seeding_time));
            context__.validate_dims("data initialization", "R", "matrix_d", context__.to_vec(n,(t - seeding_time)));
            R = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, (t - seeding_time));
            vals_r__ = context__.vals_r("R");
            pos__ = 0;
            size_t R_j_2_max__ = (t - seeding_time);
            size_t R_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                    R(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 545;
            context__.validate_dims("data initialization", "pop", "int", context__.to_vec());
            pop = int(0);
            vals_i__ = context__.vals_i("pop");
            pos__ = 0;
            pop = vals_i__[pos__++];
            current_statement_begin__ = 547;
            context__.validate_dims("data initialization", "delays", "int", context__.to_vec());
            delays = int(0);
            vals_i__ = context__.vals_i("delays");
            pos__ = 0;
            delays = vals_i__[pos__++];
            current_statement_begin__ = 548;
            validate_non_negative_index("delay_mean", "n", n);
            validate_non_negative_index("delay_mean", "delays", delays);
            context__.validate_dims("data initialization", "delay_mean", "double", context__.to_vec(n,delays));
            delay_mean = std::vector<std::vector<double> >(n, std::vector<double>(delays, double(0)));
            vals_r__ = context__.vals_r("delay_mean");
            pos__ = 0;
            size_t delay_mean_k_0_max__ = n;
            size_t delay_mean_k_1_max__ = delays;
            for (size_t k_1__ = 0; k_1__ < delay_mean_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
                    delay_mean[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 549;
            validate_non_negative_index("delay_sd", "n", n);
            validate_non_negative_index("delay_sd", "delays", delays);
            context__.validate_dims("data initialization", "delay_sd", "double", context__.to_vec(n,delays));
            delay_sd = std::vector<std::vector<double> >(n, std::vector<double>(delays, double(0)));
            vals_r__ = context__.vals_r("delay_sd");
            pos__ = 0;
            size_t delay_sd_k_0_max__ = n;
            size_t delay_sd_k_1_max__ = delays;
            for (size_t k_1__ = 0; k_1__ < delay_sd_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
                    delay_sd[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 550;
            validate_non_negative_index("delay_max", "delays", delays);
            context__.validate_dims("data initialization", "delay_max", "int", context__.to_vec(delays));
            delay_max = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("delay_max");
            pos__ = 0;
            size_t delay_max_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_max_k_0_max__; ++k_0__) {
                delay_max[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 551;
            validate_non_negative_index("delay_dist", "delays", delays);
            context__.validate_dims("data initialization", "delay_dist", "int", context__.to_vec(delays));
            delay_dist = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("delay_dist");
            pos__ = 0;
            size_t delay_dist_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_dist_k_0_max__; ++k_0__) {
                delay_dist[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 553;
            validate_non_negative_index("day_of_week", "(t - seeding_time)", (t - seeding_time));
            context__.validate_dims("data initialization", "day_of_week", "int", context__.to_vec((t - seeding_time)));
            day_of_week = std::vector<int>((t - seeding_time), int(0));
            vals_i__ = context__.vals_i("day_of_week");
            pos__ = 0;
            size_t day_of_week_k_0_max__ = (t - seeding_time);
            for (size_t k_0__ = 0; k_0__ < day_of_week_k_0_max__; ++k_0__) {
                day_of_week[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 554;
            context__.validate_dims("data initialization", "week_effect", "int", context__.to_vec());
            week_effect = int(0);
            vals_i__ = context__.vals_i("week_effect");
            pos__ = 0;
            week_effect = vals_i__[pos__++];
            current_statement_begin__ = 555;
            validate_non_negative_index("day_of_week_simplex", "n", n);
            validate_non_negative_index("day_of_week_simplex", "week_effect", week_effect);
            context__.validate_dims("data initialization", "day_of_week_simplex", "double", context__.to_vec(n,week_effect));
            day_of_week_simplex = std::vector<std::vector<double> >(n, std::vector<double>(week_effect, double(0)));
            vals_r__ = context__.vals_r("day_of_week_simplex");
            pos__ = 0;
            size_t day_of_week_simplex_k_0_max__ = n;
            size_t day_of_week_simplex_k_1_max__ = week_effect;
            for (size_t k_1__ = 0; k_1__ < day_of_week_simplex_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < day_of_week_simplex_k_0_max__; ++k_0__) {
                    day_of_week_simplex[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t day_of_week_simplex_i_0_max__ = n;
            size_t day_of_week_simplex_i_1_max__ = week_effect;
            for (size_t i_0__ = 0; i_0__ < day_of_week_simplex_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < day_of_week_simplex_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "day_of_week_simplex[i_0__][i_1__]", day_of_week_simplex[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 556;
            context__.validate_dims("data initialization", "obs_scale", "int", context__.to_vec());
            obs_scale = int(0);
            vals_i__ = context__.vals_i("obs_scale");
            pos__ = 0;
            obs_scale = vals_i__[pos__++];
            current_statement_begin__ = 557;
            validate_non_negative_index("frac_obs", "n", n);
            validate_non_negative_index("frac_obs", "obs_scale", obs_scale);
            context__.validate_dims("data initialization", "frac_obs", "double", context__.to_vec(n,obs_scale));
            frac_obs = std::vector<std::vector<double> >(n, std::vector<double>(obs_scale, double(0)));
            vals_r__ = context__.vals_r("frac_obs");
            pos__ = 0;
            size_t frac_obs_k_0_max__ = n;
            size_t frac_obs_k_1_max__ = obs_scale;
            for (size_t k_1__ = 0; k_1__ < frac_obs_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
                    frac_obs[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t frac_obs_i_0_max__ = n;
            size_t frac_obs_i_1_max__ = obs_scale;
            for (size_t i_0__ = 0; i_0__ < frac_obs_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < frac_obs_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "frac_obs[i_0__][i_1__]", frac_obs[i_0__][i_1__], 0);
                    check_less_or_equal(function__, "frac_obs[i_0__][i_1__]", frac_obs[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 558;
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            current_statement_begin__ = 559;
            validate_non_negative_index("rep_phi", "n", n);
            validate_non_negative_index("rep_phi", "model_type", model_type);
            context__.validate_dims("data initialization", "rep_phi", "double", context__.to_vec(n,model_type));
            rep_phi = std::vector<std::vector<double> >(n, std::vector<double>(model_type, double(0)));
            vals_r__ = context__.vals_r("rep_phi");
            pos__ = 0;
            size_t rep_phi_k_0_max__ = n;
            size_t rep_phi_k_1_max__ = model_type;
            for (size_t k_1__ = 0; k_1__ < rep_phi_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
                    rep_phi[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t rep_phi_i_0_max__ = n;
            size_t rep_phi_i_1_max__ = model_type;
            for (size_t i_0__ = 0; i_0__ < rep_phi_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < rep_phi_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "rep_phi[i_0__][i_1__]", rep_phi[i_0__][i_1__], 0);
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 563;
            delay_max_total = int(0);
            stan::math::fill(delay_max_total, std::numeric_limits<int>::min());
            stan::math::assign(delay_max_total,((sum(delay_max) - num_elements(delay_max)) + 1));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_simulate_infections() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("infections");
        names__.push_back("reports");
        names__.push_back("imputed_reports");
        names__.push_back("r");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back((t - seeding_time));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back((t - seeding_time));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dims__.push_back((t - seeding_time));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_simulate_infections_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 568;
            validate_non_negative_index("infections", "n", n);
            validate_non_negative_index("infections", "t", t);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> infections(n, t);
            stan::math::initialize(infections, DUMMY_VAR__);
            stan::math::fill(infections, DUMMY_VAR__);
            current_statement_begin__ = 569;
            validate_non_negative_index("reports", "n", n);
            validate_non_negative_index("reports", "(t - seeding_time)", (t - seeding_time));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> reports(n, (t - seeding_time));
            stan::math::initialize(reports, DUMMY_VAR__);
            stan::math::fill(reports, DUMMY_VAR__);
            current_statement_begin__ = 570;
            validate_non_negative_index("imputed_reports", "n", n);
            validate_non_negative_index("imputed_reports", "(t - seeding_time)", (t - seeding_time));
            std::vector<std::vector<int> > imputed_reports(n, std::vector<int>((t - seeding_time), int(0)));
            stan::math::fill(imputed_reports, std::numeric_limits<int>::min());
            current_statement_begin__ = 571;
            validate_non_negative_index("r", "n", n);
            validate_non_negative_index("r", "(t - seeding_time)", (t - seeding_time));
            std::vector<std::vector<double> > r(n, std::vector<double>((t - seeding_time), double(0)));
            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 572;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 574;
                validate_non_negative_index("gt_rev_pmf", "get_base1(gt_max, 1, \"gt_max\", 1)", get_base1(gt_max, 1, "gt_max", 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gt_rev_pmf(get_base1(gt_max, 1, "gt_max", 1));
                stan::math::initialize(gt_rev_pmf, DUMMY_VAR__);
                stan::math::fill(gt_rev_pmf, DUMMY_VAR__);
                current_statement_begin__ = 575;
                validate_non_negative_index("delay_rev_pmf", "delay_max_total", delay_max_total);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delay_rev_pmf(delay_max_total);
                stan::math::initialize(delay_rev_pmf, DUMMY_VAR__);
                stan::math::fill(delay_rev_pmf, DUMMY_VAR__);
                current_statement_begin__ = 577;
                stan::math::assign(gt_rev_pmf, reverse_mf(discretised_pmf(get_base1(get_base1(gt_mean, i, "gt_mean", 1), 1, "gt_mean", 2), get_base1(get_base1(gt_sd, i, "gt_sd", 1), 1, "gt_sd", 2), get_base1(gt_max, 1, "gt_max", 1), get_base1(gt_dist, 1, "gt_dist", 1), 1, pstream__), pstream__));
                current_statement_begin__ = 580;
                stan::math::assign(delay_rev_pmf, combine_pmfs(to_vector(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).array())), get_base1(delay_mean, i, "delay_mean", 1), get_base1(delay_sd, i, "delay_sd", 1), delay_max, delay_dist, delay_max_total, 0, 1, pstream__));
                current_statement_begin__ = 585;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            to_row_vector(generate_infections(to_vector(get_base1(R, i, "R", 1)), seeding_time, gt_rev_pmf, get_base1(initial_infections, i, "initial_infections", 1), get_base1(initial_growth, i, "initial_growth", 1), pop, future_time, pstream__)), 
                            "assigning variable infections");
                current_statement_begin__ = 590;
                stan::model::assign(reports, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            to_row_vector(convolve_to_report(to_vector(get_base1(infections, i, "infections", 1)), delay_rev_pmf, seeding_time, pstream__)), 
                            "assigning variable reports");
                current_statement_begin__ = 594;
                if (as_bool(logical_gt(week_effect, 1))) {
                    current_statement_begin__ = 595;
                    stan::model::assign(reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                to_row_vector(day_of_week_effect(to_vector(get_base1(reports, i, "reports", 1)), day_of_week, to_vector(get_base1(day_of_week_simplex, i, "day_of_week_simplex", 1)), pstream__)), 
                                "assigning variable reports");
                }
                current_statement_begin__ = 600;
                if (as_bool(obs_scale)) {
                    current_statement_begin__ = 601;
                    stan::model::assign(reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                to_row_vector(scale_obs(to_vector(get_base1(reports, i, "reports", 1)), get_base1(get_base1(frac_obs, i, "frac_obs", 1), 1, "frac_obs", 2), pstream__)), 
                                "assigning variable reports");
                }
                current_statement_begin__ = 604;
                stan::model::assign(imputed_reports, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            report_rng(to_vector(get_base1(reports, i, "reports", 1)), get_base1(rep_phi, i, "rep_phi", 1), model_type, base_rng__, pstream__), 
                            "assigning variable imputed_reports");
                current_statement_begin__ = 607;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            R_to_growth(to_vector(get_base1(R, i, "R", 1)), get_base1(get_base1(gt_mean, i, "gt_mean", 1), 1, "gt_mean", 2), get_base1(get_base1(gt_sd, i, "gt_sd", 1), 1, "gt_sd", 2), pstream__), 
                            "assigning variable r");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 568;
            size_t infections_j_2_max__ = t;
            size_t infections_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                    vars__.push_back(infections(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 569;
            size_t reports_j_2_max__ = (t - seeding_time);
            size_t reports_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < reports_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                    vars__.push_back(reports(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 570;
            size_t imputed_reports_k_0_max__ = n;
            size_t imputed_reports_k_1_max__ = (t - seeding_time);
            for (size_t k_1__ = 0; k_1__ < imputed_reports_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < imputed_reports_k_0_max__; ++k_0__) {
                    vars__.push_back(imputed_reports[k_0__][k_1__]);
                }
            }
            current_statement_begin__ = 571;
            size_t r_k_0_max__ = n;
            size_t r_k_1_max__ = (t - seeding_time);
            for (size_t k_1__ = 0; k_1__ < r_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                    vars__.push_back(r[k_0__][k_1__]);
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_simulate_infections";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t infections_j_2_max__ = t;
        size_t infections_j_1_max__ = n;
        for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t reports_j_2_max__ = (t - seeding_time);
        size_t reports_j_1_max__ = n;
        for (size_t j_2__ = 0; j_2__ < reports_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reports" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t imputed_reports_k_0_max__ = n;
        size_t imputed_reports_k_1_max__ = (t - seeding_time);
        for (size_t k_1__ = 0; k_1__ < imputed_reports_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < imputed_reports_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "imputed_reports" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t r_k_0_max__ = n;
        size_t r_k_1_max__ = (t - seeding_time);
        for (size_t k_1__ = 0; k_1__ < r_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t infections_j_2_max__ = t;
        size_t infections_j_1_max__ = n;
        for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t reports_j_2_max__ = (t - seeding_time);
        size_t reports_j_1_max__ = n;
        for (size_t j_2__ = 0; j_2__ < reports_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < reports_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reports" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t imputed_reports_k_0_max__ = n;
        size_t imputed_reports_k_1_max__ = (t - seeding_time);
        for (size_t k_1__ = 0; k_1__ < imputed_reports_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < imputed_reports_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "imputed_reports" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t r_k_0_max__ = n;
        size_t r_k_1_max__ = (t - seeding_time);
        for (size_t k_1__ = 0; k_1__ < r_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < r_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_simulate_infections_namespace::model_simulate_infections stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
