// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_estimate_secondary_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_estimate_secondary");
    reader.add_event(1, 1, "include", "functions/convolve.stan");
    reader.add_event(1, 0, "start", "functions/convolve.stan");
    reader.add_event(48, 47, "end", "functions/convolve.stan");
    reader.add_event(48, 2, "restart", "model_estimate_secondary");
    reader.add_event(48, 2, "include", "functions/pmfs.stan");
    reader.add_event(48, 0, "start", "functions/pmfs.stan");
    reader.add_event(142, 94, "end", "functions/pmfs.stan");
    reader.add_event(142, 3, "restart", "model_estimate_secondary");
    reader.add_event(142, 3, "include", "functions/observation_model.stan");
    reader.add_event(142, 0, "start", "functions/observation_model.stan");
    reader.add_event(263, 121, "end", "functions/observation_model.stan");
    reader.add_event(263, 4, "restart", "model_estimate_secondary");
    reader.add_event(263, 4, "include", "functions/secondary.stan");
    reader.add_event(263, 0, "start", "functions/secondary.stan");
    reader.add_event(316, 53, "end", "functions/secondary.stan");
    reader.add_event(316, 5, "restart", "model_estimate_secondary");
    reader.add_event(323, 12, "include", "data/secondary.stan");
    reader.add_event(323, 0, "start", "data/secondary.stan");
    reader.add_event(329, 6, "end", "data/secondary.stan");
    reader.add_event(329, 13, "restart", "model_estimate_secondary");
    reader.add_event(329, 13, "include", "data/delays.stan");
    reader.add_event(329, 0, "start", "data/delays.stan");
    reader.add_event(343, 14, "end", "data/delays.stan");
    reader.add_event(343, 14, "restart", "model_estimate_secondary");
    reader.add_event(343, 14, "include", "data/observation_model.stan");
    reader.add_event(343, 0, "start", "data/observation_model.stan");
    reader.add_event(362, 19, "end", "data/observation_model.stan");
    reader.add_event(362, 15, "restart", "model_estimate_secondary");
    reader.add_event(462, 113, "end", "model_estimate_secondary");
    return reader;
}
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& len, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        int xlen(0);
        (void) xlen;  // dummy to suppress unused var warning
        stan::math::fill(xlen, std::numeric_limits<int>::min());
        stan::math::assign(xlen,num_elements(x));
        current_statement_begin__ = 7;
        int ylen(0);
        (void) ylen;  // dummy to suppress unused var warning
        stan::math::fill(ylen, std::numeric_limits<int>::min());
        stan::math::assign(ylen,num_elements(y));
        current_statement_begin__ = 8;
        validate_non_negative_index("convolution", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> convolution(len);
        stan::math::initialize(convolution, DUMMY_VAR__);
        stan::math::fill(convolution, DUMMY_VAR__);
        stan::math::assign(convolution,rep_vector(0, len));
        current_statement_begin__ = 9;
        for (int i = 1; i <= xlen; ++i) {
            current_statement_begin__ = 10;
            for (int j = 1; j <= std::min(((len - i) + 1), ylen); ++j) {
                current_statement_begin__ = 11;
                stan::model::assign(convolution, 
                            stan::model::cons_list(stan::model::index_uni(((i + j) - 1)), stan::model::nil_index_list()), 
                            (stan::model::rvalue(convolution, stan::model::cons_list(stan::model::index_uni(((i + j) - 1)), stan::model::nil_index_list()), "convolution") + (get_base1(x, i, "x", 1) * get_base1(y, j, "y", 1))), 
                            "assigning variable convolution");
            }
        }
        current_statement_begin__ = 14;
        return stan::math::promote_scalar<fun_return_scalar_t__>(convolution);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
             const int& len, std::ostream* pstream__) const {
        return convolve(x, y, len, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_dot_product(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                         const int& len, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 22;
        int ylen(0);
        (void) ylen;  // dummy to suppress unused var warning
        stan::math::fill(ylen, std::numeric_limits<int>::min());
        stan::math::assign(ylen,num_elements(y));
        current_statement_begin__ = 23;
        validate_non_negative_index("z", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z(len);
        stan::math::initialize(z, DUMMY_VAR__);
        stan::math::fill(z, DUMMY_VAR__);
        current_statement_begin__ = 24;
        for (int s = 1; s <= len; ++s) {
            current_statement_begin__ = 25;
            stan::model::assign(z, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        dot_product(stan::model::rvalue(x, stan::model::cons_list(stan::model::index_min_max(std::max(1, ((s - ylen) + 1)), s), stan::model::nil_index_list()), "x"), tail(y, std::min(ylen, s))), 
                        "assigning variable z");
        }
        current_statement_begin__ = 29;
        return stan::math::promote_scalar<fun_return_scalar_t__>(z);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_dot_product_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& x,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& y,
                         const int& len, std::ostream* pstream__) const {
        return convolve_dot_product(x, y, len, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
convolve_to_report(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& delay_rev_pmf,
                       const int& seeding_time, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(infections));
        current_statement_begin__ = 38;
        validate_non_negative_index("reports", "(t - seeding_time)", (t - seeding_time));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reports((t - seeding_time));
        stan::math::initialize(reports, DUMMY_VAR__);
        stan::math::fill(reports, DUMMY_VAR__);
        current_statement_begin__ = 39;
        validate_non_negative_index("unobs_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> unobs_reports(t);
        stan::math::initialize(unobs_reports, DUMMY_VAR__);
        stan::math::fill(unobs_reports, DUMMY_VAR__);
        stan::math::assign(unobs_reports,infections);
        current_statement_begin__ = 40;
        int delays(0);
        (void) delays;  // dummy to suppress unused var warning
        stan::math::fill(delays, std::numeric_limits<int>::min());
        stan::math::assign(delays,num_elements(delay_rev_pmf));
        current_statement_begin__ = 41;
        if (as_bool(delays)) {
            current_statement_begin__ = 42;
            stan::math::assign(unobs_reports, convolve_dot_product(unobs_reports, delay_rev_pmf, t, pstream__));
            current_statement_begin__ = 43;
            stan::math::assign(reports, stan::model::rvalue(unobs_reports, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "unobs_reports"));
        } else {
            current_statement_begin__ = 45;
            stan::math::assign(reports, stan::model::rvalue(infections, stan::model::cons_list(stan::model::index_min_max((seeding_time + 1), t), stan::model::nil_index_list()), "infections"));
        }
        current_statement_begin__ = 47;
        return stan::math::promote_scalar<fun_return_scalar_t__>(reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct convolve_to_report_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& infections,
                       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& delay_rev_pmf,
                       const int& seeding_time, std::ostream* pstream__) const {
        return convolve_to_report(infections, delay_rev_pmf, seeding_time, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
discretised_pmf(const T0__& mu,
                    const T1__& sigma,
                    const int& n,
                    const int& dist,
                    const int& left_truncate, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 57;
        validate_non_negative_index("pmf", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(n);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        current_statement_begin__ = 58;
        if (as_bool(logical_gt(sigma, 0))) {
            {
            current_statement_begin__ = 59;
            validate_non_negative_index("upper_cdf", "(n + 1)", (n + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> upper_cdf((n + 1));
            stan::math::initialize(upper_cdf, DUMMY_VAR__);
            stan::math::fill(upper_cdf, DUMMY_VAR__);
            current_statement_begin__ = 60;
            if (as_bool(logical_eq(dist, 0))) {
                current_statement_begin__ = 61;
                for (int i = 1; i <= (n + 1); ++i) {
                    current_statement_begin__ = 62;
                    stan::model::assign(upper_cdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                lognormal_cdf(((i - 1) + left_truncate), mu, sigma), 
                                "assigning variable upper_cdf");
                }
            } else if (as_bool(logical_eq(dist, 1))) {
                {
                current_statement_begin__ = 65;
                local_scalar_t__ alpha(DUMMY_VAR__);
                (void) alpha;  // dummy to suppress unused var warning
                stan::math::initialize(alpha, DUMMY_VAR__);
                stan::math::fill(alpha, DUMMY_VAR__);
                stan::math::assign(alpha,(pow(mu, 2) / pow(sigma, 2)));
                current_statement_begin__ = 66;
                local_scalar_t__ beta(DUMMY_VAR__);
                (void) beta;  // dummy to suppress unused var warning
                stan::math::initialize(beta, DUMMY_VAR__);
                stan::math::fill(beta, DUMMY_VAR__);
                stan::math::assign(beta,(mu / pow(sigma, 2)));
                current_statement_begin__ = 67;
                for (int i = 1; i <= (n + 1); ++i) {
                    current_statement_begin__ = 68;
                    stan::model::assign(upper_cdf, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                gamma_cdf(((i - 1) + left_truncate), alpha, beta), 
                                "assigning variable upper_cdf");
                }
                }
            } else {
                current_statement_begin__ = 71;
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "Unknown distribution function provided.";
                throw std::domain_error(errmsg_stream__.str());
            }
            current_statement_begin__ = 74;
            stan::math::assign(pmf, subtract(stan::model::rvalue(upper_cdf, stan::model::cons_list(stan::model::index_min_max(2, (n + 1)), stan::model::nil_index_list()), "upper_cdf"), stan::model::rvalue(upper_cdf, stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list()), "upper_cdf")));
            current_statement_begin__ = 76;
            stan::math::assign(pmf, divide(pmf, (get_base1(upper_cdf, (n + 1), "upper_cdf", 1) - get_base1(upper_cdf, 1, "upper_cdf", 1))));
            }
        } else {
            current_statement_begin__ = 79;
            stan::math::assign(pmf, rep_vector(0, n));
            current_statement_begin__ = 80;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 82;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct discretised_pmf_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const T0__& mu,
                    const T1__& sigma,
                    const int& n,
                    const int& dist,
                    const int& left_truncate, std::ostream* pstream__) const {
        return discretised_pmf(mu, sigma, n, dist, left_truncate, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse_mf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 87;
        int max_pmf(0);
        (void) max_pmf;  // dummy to suppress unused var warning
        stan::math::fill(max_pmf, std::numeric_limits<int>::min());
        stan::math::assign(max_pmf,num_elements(pmf));
        current_statement_begin__ = 88;
        validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev_pmf(max_pmf);
        stan::math::initialize(rev_pmf, DUMMY_VAR__);
        stan::math::fill(rev_pmf, DUMMY_VAR__);
        current_statement_begin__ = 89;
        for (int d = 1; d <= max_pmf; ++d) {
            current_statement_begin__ = 90;
            stan::model::assign(rev_pmf, 
                        stan::model::cons_list(stan::model::index_uni(d), stan::model::nil_index_list()), 
                        get_base1(pmf, ((max_pmf - d) + 1), "pmf", 1), 
                        "assigning variable rev_pmf");
        }
        current_statement_begin__ = 92;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev_pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse_mf_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& pmf, std::ostream* pstream__) const {
        return reverse_mf(pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
combine_pmfs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& fixed_pmf,
                 const std::vector<T1__>& pmf_mu,
                 const std::vector<T2__>& pmf_sigma,
                 const std::vector<int>& pmf_n,
                 const std::vector<int>& dist,
                 const int& len,
                 const int& left_truncate,
                 const int& reverse_pmf, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 97;
        int n_fixed(0);
        (void) n_fixed;  // dummy to suppress unused var warning
        stan::math::fill(n_fixed, std::numeric_limits<int>::min());
        stan::math::assign(n_fixed,num_elements(fixed_pmf));
        current_statement_begin__ = 98;
        int n_variable(0);
        (void) n_variable;  // dummy to suppress unused var warning
        stan::math::fill(n_variable, std::numeric_limits<int>::min());
        stan::math::assign(n_variable,num_elements(pmf_mu));
        current_statement_begin__ = 99;
        validate_non_negative_index("pmf", "len", len);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pmf(len);
        stan::math::initialize(pmf, DUMMY_VAR__);
        stan::math::fill(pmf, DUMMY_VAR__);
        stan::math::assign(pmf,rep_vector(0, len));
        current_statement_begin__ = 100;
        if (as_bool(logical_gt(n_fixed, 0))) {
            current_statement_begin__ = 101;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_min_max(1, n_fixed), stan::model::nil_index_list()), 
                        fixed_pmf, 
                        "assigning variable pmf");
        } else if (as_bool(logical_gt(n_variable, 0))) {
            current_statement_begin__ = 103;
            stan::model::assign(pmf, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable pmf");
        }
        current_statement_begin__ = 105;
        for (int s = 1; s <= n_variable; ++s) {
            {
            current_statement_begin__ = 106;
            validate_non_negative_index("variable_pmf", "get_base1(pmf_n, s, \"pmf_n\", 1)", get_base1(pmf_n, s, "pmf_n", 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> variable_pmf(get_base1(pmf_n, s, "pmf_n", 1));
            stan::math::initialize(variable_pmf, DUMMY_VAR__);
            stan::math::fill(variable_pmf, DUMMY_VAR__);
            current_statement_begin__ = 107;
            stan::math::assign(variable_pmf, discretised_pmf(get_base1(pmf_mu, s, "pmf_mu", 1), get_base1(pmf_sigma, s, "pmf_sigma", 1), get_base1(pmf_n, s, "pmf_n", 1), get_base1(dist, s, "dist", 1), left_truncate, pstream__));
            current_statement_begin__ = 108;
            stan::math::assign(pmf, convolve(pmf, variable_pmf, len, pstream__));
            }
        }
        current_statement_begin__ = 110;
        if (as_bool(reverse_pmf)) {
            current_statement_begin__ = 111;
            stan::math::assign(pmf, reverse_mf(pmf, pstream__));
        }
        current_statement_begin__ = 113;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pmf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct combine_pmfs_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& fixed_pmf,
                 const std::vector<T1__>& pmf_mu,
                 const std::vector<T2__>& pmf_sigma,
                 const std::vector<int>& pmf_n,
                 const std::vector<int>& dist,
                 const int& len,
                 const int& left_truncate,
                 const int& reverse_pmf, std::ostream* pstream__) const {
        return combine_pmfs(fixed_pmf, pmf_mu, pmf_sigma, pmf_n, dist, len, left_truncate, reverse_pmf, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
delays_lp(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const std::vector<int>& delay_dist,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 119;
        int mean_delays(0);
        (void) mean_delays;  // dummy to suppress unused var warning
        stan::math::fill(mean_delays, std::numeric_limits<int>::min());
        stan::math::assign(mean_delays,num_elements(delay_mean));
        current_statement_begin__ = 120;
        int sd_delays(0);
        (void) sd_delays;  // dummy to suppress unused var warning
        stan::math::fill(sd_delays, std::numeric_limits<int>::min());
        stan::math::assign(sd_delays,num_elements(delay_sd));
        current_statement_begin__ = 121;
        if (as_bool(mean_delays)) {
            current_statement_begin__ = 122;
            for (int s = 1; s <= mean_delays; ++s) {
                current_statement_begin__ = 123;
                if (as_bool(logical_gt(get_base1(delay_mean_sd, s, "delay_mean_sd", 1), 0))) {
                    current_statement_begin__ = 125;
                    lp_accum__.add((normal_log(get_base1(delay_mean, s, "delay_mean", 1), get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1)) * weight));
                    current_statement_begin__ = 127;
                    if (as_bool(get_base1(delay_dist, s, "delay_dist", 1))) {
                        current_statement_begin__ = 128;
                        lp_accum__.add((-(normal_ccdf_log(0, get_base1(delay_mean_mean, s, "delay_mean_mean", 1), get_base1(delay_mean_sd, s, "delay_mean_sd", 1))) * weight));
                    }
                }
            }
        }
        current_statement_begin__ = 133;
        if (as_bool(sd_delays)) {
            current_statement_begin__ = 134;
            for (int s = 1; s <= sd_delays; ++s) {
                current_statement_begin__ = 135;
                if (as_bool(logical_gt(get_base1(delay_sd_sd, s, "delay_sd_sd", 1), 0))) {
                    current_statement_begin__ = 137;
                    lp_accum__.add((normal_log(get_base1(delay_sd, s, "delay_sd", 1), get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1)) * weight));
                    current_statement_begin__ = 138;
                    lp_accum__.add((-(normal_ccdf_log(0, get_base1(delay_sd_mean, s, "delay_sd_mean", 1), get_base1(delay_sd_sd, s, "delay_sd_sd", 1))) * weight));
                }
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct delays_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& delay_mean,
              const std::vector<T1__>& delay_mean_mean,
              const std::vector<T2__>& delay_mean_sd,
              const std::vector<T3__>& delay_sd,
              const std::vector<T4__>& delay_sd_mean,
              const std::vector<T5__>& delay_sd_sd,
              const std::vector<int>& delay_dist,
              const int& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return delays_lp(delay_mean, delay_mean_mean, delay_mean_sd, delay_sd, delay_sd_mean, delay_sd_sd, delay_dist, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
day_of_week_effect(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 145;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 146;
        int wl(0);
        (void) wl;  // dummy to suppress unused var warning
        stan::math::fill(wl, std::numeric_limits<int>::min());
        stan::math::assign(wl,num_elements(effect));
        current_statement_begin__ = 148;
        validate_non_negative_index("scaled_effect", "wl", wl);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_effect(wl);
        stan::math::initialize(scaled_effect, DUMMY_VAR__);
        stan::math::fill(scaled_effect, DUMMY_VAR__);
        stan::math::assign(scaled_effect,multiply(wl, effect));
        current_statement_begin__ = 149;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 150;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 152;
            stan::model::assign(scaled_reports, 
                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                        (get_base1(reports, s, "reports", 1) * get_base1(scaled_effect, get_base1(day_of_week, s, "day_of_week", 1), "scaled_effect", 1)), 
                        "assigning variable scaled_reports");
        }
        current_statement_begin__ = 154;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct day_of_week_effect_functor__ {
    template <typename T0__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                       const std::vector<int>& day_of_week,
                       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& effect, std::ostream* pstream__) const {
        return day_of_week_effect(reports, day_of_week, effect, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
scale_obs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 159;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 160;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 161;
        stan::math::assign(scaled_reports, multiply(reports, frac_obs));
        current_statement_begin__ = 162;
        return stan::math::promote_scalar<fun_return_scalar_t__>(scaled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct scale_obs_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
              const T1__& frac_obs, std::ostream* pstream__) const {
        return scale_obs(reports, frac_obs, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
truncate(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& trunc_rev_cmf,
             const int& reconstruct, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 166;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 167;
        validate_non_negative_index("trunc_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_reports(t);
        stan::math::initialize(trunc_reports, DUMMY_VAR__);
        stan::math::fill(trunc_reports, DUMMY_VAR__);
        stan::math::assign(trunc_reports,reports);
        current_statement_begin__ = 169;
        int trunc_max(0);
        (void) trunc_max;  // dummy to suppress unused var warning
        stan::math::fill(trunc_max, std::numeric_limits<int>::min());
        stan::math::assign(trunc_max,num_elements(trunc_rev_cmf));
        current_statement_begin__ = 170;
        int first_t(0);
        (void) first_t;  // dummy to suppress unused var warning
        stan::math::fill(first_t, std::numeric_limits<int>::min());
        stan::math::assign(first_t,((t - trunc_max) + 1));
        current_statement_begin__ = 172;
        if (as_bool(reconstruct)) {
            current_statement_begin__ = 173;
            stan::model::assign(trunc_reports, 
                        stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                        stan::model::deep_copy(elt_divide(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), trunc_rev_cmf)), 
                        "assigning variable trunc_reports");
        } else {
            current_statement_begin__ = 175;
            stan::model::assign(trunc_reports, 
                        stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), 
                        stan::model::deep_copy(elt_multiply(stan::model::rvalue(trunc_reports, stan::model::cons_list(stan::model::index_min_max(first_t, t), stan::model::nil_index_list()), "trunc_reports"), trunc_rev_cmf)), 
                        "assigning variable trunc_reports");
        }
        current_statement_begin__ = 177;
        return stan::math::promote_scalar<fun_return_scalar_t__>(trunc_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncate_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
             const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& trunc_rev_cmf,
             const int& reconstruct, std::ostream* pstream__) const {
        return truncate(reports, trunc_rev_cmf, reconstruct, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 183;
        int truncation(0);
        (void) truncation;  // dummy to suppress unused var warning
        stan::math::fill(truncation, std::numeric_limits<int>::min());
        stan::math::assign(truncation,num_elements(truncation_mean));
        current_statement_begin__ = 184;
        if (as_bool(truncation)) {
            current_statement_begin__ = 185;
            if (as_bool(logical_gt(get_base1(trunc_mean_sd, 1, "trunc_mean_sd", 1), 0))) {
                current_statement_begin__ = 187;
                lp_accum__.add(normal_log<propto__>(truncation_mean, trunc_mean_mean, trunc_mean_sd));
            }
            current_statement_begin__ = 189;
            if (as_bool(logical_gt(get_base1(trunc_sd_sd, 1, "trunc_sd_sd", 1), 0))) {
                current_statement_begin__ = 191;
                lp_accum__.add(normal_log<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct truncation_lp_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<T0__>& truncation_mean,
                  const std::vector<T1__>& truncation_sd,
                  const std::vector<T2__>& trunc_mean_mean,
                  const std::vector<T3__>& trunc_mean_sd,
                  const std::vector<T4__>& trunc_sd_mean,
                  const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return truncation_lp(truncation_mean, truncation_sd, trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const T3__& phi_mean,
              const T4__& phi_sd,
              const int& model_type,
              const T6__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T6__, T_lp__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 199;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 200;
        if (as_bool(model_type)) {
            current_statement_begin__ = 202;
            lp_accum__.add(normal_log<propto__>(get_base1(rep_phi, model_type, "rep_phi", 1), phi_mean, phi_sd));
            if (get_base1(rep_phi, model_type, "rep_phi", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, phi_mean, phi_sd));
            current_statement_begin__ = 203;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 207;
        if (as_bool(logical_gt(sqrt_phi, 1e4))) {
            current_statement_begin__ = 208;
            if (as_bool(logical_eq(weight, 1))) {
                current_statement_begin__ = 209;
                lp_accum__.add(poisson_log<propto__>(cases, reports));
            } else {
                current_statement_begin__ = 211;
                lp_accum__.add((poisson_log(cases, reports) * weight));
            }
        } else {
            current_statement_begin__ = 214;
            if (as_bool(logical_eq(weight, 1))) {
                current_statement_begin__ = 215;
                lp_accum__.add(neg_binomial_2_log<propto__>(cases, reports, sqrt_phi));
            } else {
                current_statement_begin__ = 217;
                lp_accum__.add(neg_binomial_2_log(cases, reports, sqrt_phi));
            }
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_lp_functor__ {
    template <typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const std::vector<int>& cases,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
              const std::vector<T2__>& rep_phi,
              const T3__& phi_mean,
              const T4__& phi_sd,
              const int& model_type,
              const T6__& weight, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return report_lp(cases, reports, rep_phi, phi_mean, phi_sd, model_type, weight, lp__, lp_accum__, pstream__);
    }
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
report_log_lik(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T1__, T2__, T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 225;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 226;
        validate_non_negative_index("log_lik", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(t);
        stan::math::initialize(log_lik, DUMMY_VAR__);
        stan::math::fill(log_lik, DUMMY_VAR__);
        current_statement_begin__ = 227;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 228;
        if (as_bool(model_type)) {
            current_statement_begin__ = 230;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 234;
        if (as_bool(logical_gt(sqrt_phi, 1e4))) {
            current_statement_begin__ = 235;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 236;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (poisson_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1)) * weight), 
                            "assigning variable log_lik");
            }
        } else {
            current_statement_begin__ = 239;
            for (int i = 1; i <= t; ++i) {
                current_statement_begin__ = 240;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (neg_binomial_2_log(get_base1(cases, i, "cases", 1), get_base1(reports, i, "reports", 1), sqrt_phi) * weight), 
                            "assigning variable log_lik");
            }
        }
        current_statement_begin__ = 243;
        return stan::math::promote_scalar<fun_return_scalar_t__>(log_lik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_log_lik_functor__ {
    template <typename T1__, typename T2__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T1__, T2__, T4__>::type, Eigen::Dynamic, 1>
    operator()(const std::vector<int>& cases,
                   const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& reports,
                   const std::vector<T2__>& rep_phi,
                   const int& model_type,
                   const T4__& weight, std::ostream* pstream__) const {
        return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
    }
};
template <typename T0__, typename T1__, class RNG>
std::vector<int>
report_rng(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 247;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 248;
        validate_non_negative_index("sampled_reports", "t", t);
        std::vector<int  > sampled_reports(t, int(0));
        stan::math::fill(sampled_reports, std::numeric_limits<int>::min());
        current_statement_begin__ = 249;
        local_scalar_t__ sqrt_phi(DUMMY_VAR__);
        (void) sqrt_phi;  // dummy to suppress unused var warning
        stan::math::initialize(sqrt_phi, DUMMY_VAR__);
        stan::math::fill(sqrt_phi, DUMMY_VAR__);
        stan::math::assign(sqrt_phi,1e5);
        current_statement_begin__ = 250;
        if (as_bool(model_type)) {
            current_statement_begin__ = 251;
            stan::math::assign(sqrt_phi, (1 / stan::math::sqrt(get_base1(rep_phi, model_type, "rep_phi", 1))));
        }
        current_statement_begin__ = 254;
        for (int s = 1; s <= t; ++s) {
            current_statement_begin__ = 256;
            if (as_bool(logical_gt(sqrt_phi, 1e4))) {
                current_statement_begin__ = 257;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            poisson_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), base_rng__), 
                            "assigning variable sampled_reports");
            } else {
                current_statement_begin__ = 259;
                stan::model::assign(sampled_reports, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            neg_binomial_2_rng((logical_gt(get_base1(reports, s, "reports", 1), 1e8) ? 1e8 : get_base1(reports, s, "reports", 1) ), sqrt_phi, base_rng__), 
                            "assigning variable sampled_reports");
            }
        }
        current_statement_begin__ = 262;
        return stan::math::promote_scalar<fun_return_scalar_t__>(sampled_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct report_rng_functor__ {
    template <typename T0__, typename T1__, class RNG>
        std::vector<int>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
               const std::vector<T1__>& rep_phi,
               const int& model_type, RNG& base_rng__, std::ostream* pstream__) const {
        return report_rng(reports, rep_phi, model_type, base_rng__, pstream__);
    }
};
template <typename T0__, typename T2__, typename T3__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__>::type, Eigen::Dynamic, 1>
calculate_secondary(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                        const std::vector<int>& obs,
                        const std::vector<T2__>& frac_obs,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& delay_rev_pmf,
                        const int& cumulative,
                        const int& historic,
                        const int& primary_hist_additive,
                        const int& current,
                        const int& primary_current_additive,
                        const int& predict, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 269;
        int t(0);
        (void) t;  // dummy to suppress unused var warning
        stan::math::fill(t, std::numeric_limits<int>::min());
        stan::math::assign(t,num_elements(reports));
        current_statement_begin__ = 270;
        int obs_scale(0);
        (void) obs_scale;  // dummy to suppress unused var warning
        stan::math::fill(obs_scale, std::numeric_limits<int>::min());
        stan::math::assign(obs_scale,num_elements(frac_obs));
        current_statement_begin__ = 271;
        validate_non_negative_index("scaled_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> scaled_reports(t);
        stan::math::initialize(scaled_reports, DUMMY_VAR__);
        stan::math::fill(scaled_reports, DUMMY_VAR__);
        current_statement_begin__ = 272;
        validate_non_negative_index("conv_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> conv_reports(t);
        stan::math::initialize(conv_reports, DUMMY_VAR__);
        stan::math::fill(conv_reports, DUMMY_VAR__);
        stan::math::assign(conv_reports,rep_vector(1e-5, t));
        current_statement_begin__ = 273;
        validate_non_negative_index("secondary_reports", "t", t);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> secondary_reports(t);
        stan::math::initialize(secondary_reports, DUMMY_VAR__);
        stan::math::fill(secondary_reports, DUMMY_VAR__);
        stan::math::assign(secondary_reports,rep_vector(0.0, t));
        current_statement_begin__ = 275;
        if (as_bool(obs_scale)) {
            current_statement_begin__ = 276;
            stan::math::assign(scaled_reports, scale_obs(reports, get_base1(frac_obs, 1, "frac_obs", 1), pstream__));
        } else {
            current_statement_begin__ = 278;
            stan::math::assign(scaled_reports, reports);
        }
        current_statement_begin__ = 281;
        stan::math::assign(conv_reports, add(conv_reports, convolve_to_report(scaled_reports, delay_rev_pmf, 0, pstream__)));
        current_statement_begin__ = 285;
        for (int i = 1; i <= t; ++i) {
            current_statement_begin__ = 287;
            if (as_bool((primitive_value(cumulative) && primitive_value(logical_gt(i, 1))))) {
                current_statement_begin__ = 288;
                if (as_bool(logical_gt(i, predict))) {
                    current_statement_begin__ = 289;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(secondary_reports, (i - 1), "secondary_reports", 1), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 291;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(obs, (i - 1), "obs", 1), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 295;
            if (as_bool(historic)) {
                current_statement_begin__ = 296;
                if (as_bool(primary_hist_additive)) {
                    current_statement_begin__ = 297;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") + get_base1(conv_reports, i, "conv_reports", 1)), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 299;
                    if (as_bool(logical_gt(get_base1(conv_reports, i, "conv_reports", 1), get_base1(secondary_reports, i, "secondary_reports", 1)))) {
                        current_statement_begin__ = 300;
                        stan::model::assign(conv_reports, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(secondary_reports, i, "secondary_reports", 1), 
                                    "assigning variable conv_reports");
                    }
                    current_statement_begin__ = 302;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") - get_base1(conv_reports, i, "conv_reports", 1)), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 306;
            if (as_bool(current)) {
                current_statement_begin__ = 307;
                if (as_bool(primary_current_additive)) {
                    current_statement_begin__ = 308;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") + get_base1(scaled_reports, i, "scaled_reports", 1)), 
                                "assigning variable secondary_reports");
                } else {
                    current_statement_begin__ = 310;
                    stan::model::assign(secondary_reports, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(secondary_reports, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "secondary_reports") - get_base1(scaled_reports, i, "scaled_reports", 1)), 
                                "assigning variable secondary_reports");
                }
            }
            current_statement_begin__ = 313;
            stan::model::assign(secondary_reports, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (1e-6 + get_base1(secondary_reports, i, "secondary_reports", 1)), 
                        "assigning variable secondary_reports");
        }
        current_statement_begin__ = 315;
        return stan::math::promote_scalar<fun_return_scalar_t__>(secondary_reports);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct calculate_secondary_functor__ {
    template <typename T0__, typename T2__, typename T3__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& reports,
                        const std::vector<int>& obs,
                        const std::vector<T2__>& frac_obs,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& delay_rev_pmf,
                        const int& cumulative,
                        const int& historic,
                        const int& primary_hist_additive,
                        const int& current,
                        const int& primary_current_additive,
                        const int& predict, std::ostream* pstream__) const {
        return calculate_secondary(reports, obs, frac_obs, delay_rev_pmf, cumulative, historic, primary_hist_additive, current, primary_current_additive, predict, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_estimate_secondary
  : public stan::model::model_base_crtp<model_estimate_secondary> {
private:
        int t;
        std::vector<int> obs;
        vector_d primary;
        int burn_in;
        int seeding_time;
        int cumulative;
        int historic;
        int primary_hist_additive;
        int current;
        int primary_current_additive;
        int delays;
        int n_uncertain_mean_delays;
        int n_uncertain_sd_delays;
        int n_fixed_delays;
        std::vector<int> uncertain_mean_delays;
        std::vector<int> uncertain_sd_delays;
        std::vector<int> fixed_delays;
        std::vector<double> delay_mean_sd;
        std::vector<double> delay_mean_mean;
        std::vector<double> delay_sd_mean;
        std::vector<double> delay_sd_sd;
        std::vector<int> delay_max;
        std::vector<int> delay_dist;
        std::vector<int> day_of_week;
        int model_type;
        double phi_mean;
        double phi_sd;
        int week_effect;
        int truncation;
        std::vector<double> trunc_mean_mean;
        std::vector<double> trunc_mean_sd;
        std::vector<double> trunc_sd_mean;
        std::vector<double> trunc_sd_sd;
        std::vector<int> trunc_max;
        std::vector<int> trunc_fixed;
        std::vector<int> trunc_dist;
        int obs_scale;
        double obs_scale_mean;
        double obs_scale_sd;
        double obs_weight;
        int likelihood;
        int return_likelihood;
        int delay_max_fixed;
        int delay_max_total;
        vector_d trunc_fixed_pmf;
        vector_d delays_fixed_pmf;
public:
    model_estimate_secondary(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_estimate_secondary(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_estimate_secondary_namespace::model_estimate_secondary";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 320;
            context__.validate_dims("data initialization", "t", "int", context__.to_vec());
            t = int(0);
            vals_i__ = context__.vals_i("t");
            pos__ = 0;
            t = vals_i__[pos__++];
            current_statement_begin__ = 321;
            validate_non_negative_index("obs", "t", t);
            context__.validate_dims("data initialization", "obs", "int", context__.to_vec(t));
            obs = std::vector<int>(t, int(0));
            vals_i__ = context__.vals_i("obs");
            pos__ = 0;
            size_t obs_k_0_max__ = t;
            for (size_t k_0__ = 0; k_0__ < obs_k_0_max__; ++k_0__) {
                obs[k_0__] = vals_i__[pos__++];
            }
            size_t obs_i_0_max__ = t;
            for (size_t i_0__ = 0; i_0__ < obs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "obs[i_0__]", obs[i_0__], 0);
            }
            current_statement_begin__ = 322;
            validate_non_negative_index("primary", "t", t);
            context__.validate_dims("data initialization", "primary", "vector_d", context__.to_vec(t));
            primary = Eigen::Matrix<double, Eigen::Dynamic, 1>(t);
            vals_r__ = context__.vals_r("primary");
            pos__ = 0;
            size_t primary_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < primary_j_1_max__; ++j_1__) {
                primary(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 323;
            context__.validate_dims("data initialization", "burn_in", "int", context__.to_vec());
            burn_in = int(0);
            vals_i__ = context__.vals_i("burn_in");
            pos__ = 0;
            burn_in = vals_i__[pos__++];
            current_statement_begin__ = 324;
            context__.validate_dims("data initialization", "seeding_time", "int", context__.to_vec());
            seeding_time = int(0);
            vals_i__ = context__.vals_i("seeding_time");
            pos__ = 0;
            seeding_time = vals_i__[pos__++];
            current_statement_begin__ = 325;
            context__.validate_dims("data initialization", "cumulative", "int", context__.to_vec());
            cumulative = int(0);
            vals_i__ = context__.vals_i("cumulative");
            pos__ = 0;
            cumulative = vals_i__[pos__++];
            current_statement_begin__ = 326;
            context__.validate_dims("data initialization", "historic", "int", context__.to_vec());
            historic = int(0);
            vals_i__ = context__.vals_i("historic");
            pos__ = 0;
            historic = vals_i__[pos__++];
            current_statement_begin__ = 327;
            context__.validate_dims("data initialization", "primary_hist_additive", "int", context__.to_vec());
            primary_hist_additive = int(0);
            vals_i__ = context__.vals_i("primary_hist_additive");
            pos__ = 0;
            primary_hist_additive = vals_i__[pos__++];
            current_statement_begin__ = 328;
            context__.validate_dims("data initialization", "current", "int", context__.to_vec());
            current = int(0);
            vals_i__ = context__.vals_i("current");
            pos__ = 0;
            current = vals_i__[pos__++];
            current_statement_begin__ = 329;
            context__.validate_dims("data initialization", "primary_current_additive", "int", context__.to_vec());
            primary_current_additive = int(0);
            vals_i__ = context__.vals_i("primary_current_additive");
            pos__ = 0;
            primary_current_additive = vals_i__[pos__++];
            current_statement_begin__ = 330;
            context__.validate_dims("data initialization", "delays", "int", context__.to_vec());
            delays = int(0);
            vals_i__ = context__.vals_i("delays");
            pos__ = 0;
            delays = vals_i__[pos__++];
            current_statement_begin__ = 331;
            context__.validate_dims("data initialization", "n_uncertain_mean_delays", "int", context__.to_vec());
            n_uncertain_mean_delays = int(0);
            vals_i__ = context__.vals_i("n_uncertain_mean_delays");
            pos__ = 0;
            n_uncertain_mean_delays = vals_i__[pos__++];
            current_statement_begin__ = 332;
            context__.validate_dims("data initialization", "n_uncertain_sd_delays", "int", context__.to_vec());
            n_uncertain_sd_delays = int(0);
            vals_i__ = context__.vals_i("n_uncertain_sd_delays");
            pos__ = 0;
            n_uncertain_sd_delays = vals_i__[pos__++];
            current_statement_begin__ = 333;
            context__.validate_dims("data initialization", "n_fixed_delays", "int", context__.to_vec());
            n_fixed_delays = int(0);
            vals_i__ = context__.vals_i("n_fixed_delays");
            pos__ = 0;
            n_fixed_delays = vals_i__[pos__++];
            current_statement_begin__ = 335;
            validate_non_negative_index("uncertain_mean_delays", "n_uncertain_mean_delays", n_uncertain_mean_delays);
            context__.validate_dims("data initialization", "uncertain_mean_delays", "int", context__.to_vec(n_uncertain_mean_delays));
            uncertain_mean_delays = std::vector<int>(n_uncertain_mean_delays, int(0));
            vals_i__ = context__.vals_i("uncertain_mean_delays");
            pos__ = 0;
            size_t uncertain_mean_delays_k_0_max__ = n_uncertain_mean_delays;
            for (size_t k_0__ = 0; k_0__ < uncertain_mean_delays_k_0_max__; ++k_0__) {
                uncertain_mean_delays[k_0__] = vals_i__[pos__++];
            }
            size_t uncertain_mean_delays_i_0_max__ = n_uncertain_mean_delays;
            for (size_t i_0__ = 0; i_0__ < uncertain_mean_delays_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "uncertain_mean_delays[i_0__]", uncertain_mean_delays[i_0__], 1);
                check_less_or_equal(function__, "uncertain_mean_delays[i_0__]", uncertain_mean_delays[i_0__], delays);
            }
            current_statement_begin__ = 336;
            validate_non_negative_index("uncertain_sd_delays", "n_uncertain_sd_delays", n_uncertain_sd_delays);
            context__.validate_dims("data initialization", "uncertain_sd_delays", "int", context__.to_vec(n_uncertain_sd_delays));
            uncertain_sd_delays = std::vector<int>(n_uncertain_sd_delays, int(0));
            vals_i__ = context__.vals_i("uncertain_sd_delays");
            pos__ = 0;
            size_t uncertain_sd_delays_k_0_max__ = n_uncertain_sd_delays;
            for (size_t k_0__ = 0; k_0__ < uncertain_sd_delays_k_0_max__; ++k_0__) {
                uncertain_sd_delays[k_0__] = vals_i__[pos__++];
            }
            size_t uncertain_sd_delays_i_0_max__ = n_uncertain_sd_delays;
            for (size_t i_0__ = 0; i_0__ < uncertain_sd_delays_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "uncertain_sd_delays[i_0__]", uncertain_sd_delays[i_0__], 1);
                check_less_or_equal(function__, "uncertain_sd_delays[i_0__]", uncertain_sd_delays[i_0__], delays);
            }
            current_statement_begin__ = 337;
            validate_non_negative_index("fixed_delays", "n_fixed_delays", n_fixed_delays);
            context__.validate_dims("data initialization", "fixed_delays", "int", context__.to_vec(n_fixed_delays));
            fixed_delays = std::vector<int>(n_fixed_delays, int(0));
            vals_i__ = context__.vals_i("fixed_delays");
            pos__ = 0;
            size_t fixed_delays_k_0_max__ = n_fixed_delays;
            for (size_t k_0__ = 0; k_0__ < fixed_delays_k_0_max__; ++k_0__) {
                fixed_delays[k_0__] = vals_i__[pos__++];
            }
            size_t fixed_delays_i_0_max__ = n_fixed_delays;
            for (size_t i_0__ = 0; i_0__ < fixed_delays_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "fixed_delays[i_0__]", fixed_delays[i_0__], 1);
                check_less_or_equal(function__, "fixed_delays[i_0__]", fixed_delays[i_0__], delays);
            }
            current_statement_begin__ = 338;
            validate_non_negative_index("delay_mean_sd", "delays", delays);
            context__.validate_dims("data initialization", "delay_mean_sd", "double", context__.to_vec(delays));
            delay_mean_sd = std::vector<double>(delays, double(0));
            vals_r__ = context__.vals_r("delay_mean_sd");
            pos__ = 0;
            size_t delay_mean_sd_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_mean_sd_k_0_max__; ++k_0__) {
                delay_mean_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 339;
            validate_non_negative_index("delay_mean_mean", "delays", delays);
            context__.validate_dims("data initialization", "delay_mean_mean", "double", context__.to_vec(delays));
            delay_mean_mean = std::vector<double>(delays, double(0));
            vals_r__ = context__.vals_r("delay_mean_mean");
            pos__ = 0;
            size_t delay_mean_mean_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_mean_mean_k_0_max__; ++k_0__) {
                delay_mean_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 340;
            validate_non_negative_index("delay_sd_mean", "delays", delays);
            context__.validate_dims("data initialization", "delay_sd_mean", "double", context__.to_vec(delays));
            delay_sd_mean = std::vector<double>(delays, double(0));
            vals_r__ = context__.vals_r("delay_sd_mean");
            pos__ = 0;
            size_t delay_sd_mean_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_sd_mean_k_0_max__; ++k_0__) {
                delay_sd_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 341;
            validate_non_negative_index("delay_sd_sd", "delays", delays);
            context__.validate_dims("data initialization", "delay_sd_sd", "double", context__.to_vec(delays));
            delay_sd_sd = std::vector<double>(delays, double(0));
            vals_r__ = context__.vals_r("delay_sd_sd");
            pos__ = 0;
            size_t delay_sd_sd_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_sd_sd_k_0_max__; ++k_0__) {
                delay_sd_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 342;
            validate_non_negative_index("delay_max", "delays", delays);
            context__.validate_dims("data initialization", "delay_max", "int", context__.to_vec(delays));
            delay_max = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("delay_max");
            pos__ = 0;
            size_t delay_max_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_max_k_0_max__; ++k_0__) {
                delay_max[k_0__] = vals_i__[pos__++];
            }
            size_t delay_max_i_0_max__ = delays;
            for (size_t i_0__ = 0; i_0__ < delay_max_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "delay_max[i_0__]", delay_max[i_0__], 1);
            }
            current_statement_begin__ = 343;
            validate_non_negative_index("delay_dist", "delays", delays);
            context__.validate_dims("data initialization", "delay_dist", "int", context__.to_vec(delays));
            delay_dist = std::vector<int>(delays, int(0));
            vals_i__ = context__.vals_i("delay_dist");
            pos__ = 0;
            size_t delay_dist_k_0_max__ = delays;
            for (size_t k_0__ = 0; k_0__ < delay_dist_k_0_max__; ++k_0__) {
                delay_dist[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 344;
            validate_non_negative_index("day_of_week", "(t - seeding_time)", (t - seeding_time));
            context__.validate_dims("data initialization", "day_of_week", "int", context__.to_vec((t - seeding_time)));
            day_of_week = std::vector<int>((t - seeding_time), int(0));
            vals_i__ = context__.vals_i("day_of_week");
            pos__ = 0;
            size_t day_of_week_k_0_max__ = (t - seeding_time);
            for (size_t k_0__ = 0; k_0__ < day_of_week_k_0_max__; ++k_0__) {
                day_of_week[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 345;
            context__.validate_dims("data initialization", "model_type", "int", context__.to_vec());
            model_type = int(0);
            vals_i__ = context__.vals_i("model_type");
            pos__ = 0;
            model_type = vals_i__[pos__++];
            current_statement_begin__ = 346;
            context__.validate_dims("data initialization", "phi_mean", "double", context__.to_vec());
            phi_mean = double(0);
            vals_r__ = context__.vals_r("phi_mean");
            pos__ = 0;
            phi_mean = vals_r__[pos__++];
            current_statement_begin__ = 347;
            context__.validate_dims("data initialization", "phi_sd", "double", context__.to_vec());
            phi_sd = double(0);
            vals_r__ = context__.vals_r("phi_sd");
            pos__ = 0;
            phi_sd = vals_r__[pos__++];
            current_statement_begin__ = 348;
            context__.validate_dims("data initialization", "week_effect", "int", context__.to_vec());
            week_effect = int(0);
            vals_i__ = context__.vals_i("week_effect");
            pos__ = 0;
            week_effect = vals_i__[pos__++];
            current_statement_begin__ = 349;
            context__.validate_dims("data initialization", "truncation", "int", context__.to_vec());
            truncation = int(0);
            vals_i__ = context__.vals_i("truncation");
            pos__ = 0;
            truncation = vals_i__[pos__++];
            current_statement_begin__ = 350;
            validate_non_negative_index("trunc_mean_mean", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_mean_mean", "double", context__.to_vec(truncation));
            trunc_mean_mean = std::vector<double>(truncation, double(0));
            vals_r__ = context__.vals_r("trunc_mean_mean");
            pos__ = 0;
            size_t trunc_mean_mean_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_mean_mean_k_0_max__; ++k_0__) {
                trunc_mean_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 351;
            validate_non_negative_index("trunc_mean_sd", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_mean_sd", "double", context__.to_vec(truncation));
            trunc_mean_sd = std::vector<double>(truncation, double(0));
            vals_r__ = context__.vals_r("trunc_mean_sd");
            pos__ = 0;
            size_t trunc_mean_sd_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_mean_sd_k_0_max__; ++k_0__) {
                trunc_mean_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 352;
            validate_non_negative_index("trunc_sd_mean", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_sd_mean", "double", context__.to_vec(truncation));
            trunc_sd_mean = std::vector<double>(truncation, double(0));
            vals_r__ = context__.vals_r("trunc_sd_mean");
            pos__ = 0;
            size_t trunc_sd_mean_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_sd_mean_k_0_max__; ++k_0__) {
                trunc_sd_mean[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 353;
            validate_non_negative_index("trunc_sd_sd", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_sd_sd", "double", context__.to_vec(truncation));
            trunc_sd_sd = std::vector<double>(truncation, double(0));
            vals_r__ = context__.vals_r("trunc_sd_sd");
            pos__ = 0;
            size_t trunc_sd_sd_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_sd_sd_k_0_max__; ++k_0__) {
                trunc_sd_sd[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 354;
            validate_non_negative_index("trunc_max", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_max", "int", context__.to_vec(truncation));
            trunc_max = std::vector<int>(truncation, int(0));
            vals_i__ = context__.vals_i("trunc_max");
            pos__ = 0;
            size_t trunc_max_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_max_k_0_max__; ++k_0__) {
                trunc_max[k_0__] = vals_i__[pos__++];
            }
            size_t trunc_max_i_0_max__ = truncation;
            for (size_t i_0__ = 0; i_0__ < trunc_max_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "trunc_max[i_0__]", trunc_max[i_0__], 1);
            }
            current_statement_begin__ = 355;
            validate_non_negative_index("trunc_fixed", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_fixed", "int", context__.to_vec(truncation));
            trunc_fixed = std::vector<int>(truncation, int(0));
            vals_i__ = context__.vals_i("trunc_fixed");
            pos__ = 0;
            size_t trunc_fixed_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_fixed_k_0_max__; ++k_0__) {
                trunc_fixed[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 356;
            validate_non_negative_index("trunc_dist", "truncation", truncation);
            context__.validate_dims("data initialization", "trunc_dist", "int", context__.to_vec(truncation));
            trunc_dist = std::vector<int>(truncation, int(0));
            vals_i__ = context__.vals_i("trunc_dist");
            pos__ = 0;
            size_t trunc_dist_k_0_max__ = truncation;
            for (size_t k_0__ = 0; k_0__ < trunc_dist_k_0_max__; ++k_0__) {
                trunc_dist[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 357;
            context__.validate_dims("data initialization", "obs_scale", "int", context__.to_vec());
            obs_scale = int(0);
            vals_i__ = context__.vals_i("obs_scale");
            pos__ = 0;
            obs_scale = vals_i__[pos__++];
            current_statement_begin__ = 358;
            context__.validate_dims("data initialization", "obs_scale_mean", "double", context__.to_vec());
            obs_scale_mean = double(0);
            vals_r__ = context__.vals_r("obs_scale_mean");
            pos__ = 0;
            obs_scale_mean = vals_r__[pos__++];
            current_statement_begin__ = 359;
            context__.validate_dims("data initialization", "obs_scale_sd", "double", context__.to_vec());
            obs_scale_sd = double(0);
            vals_r__ = context__.vals_r("obs_scale_sd");
            pos__ = 0;
            obs_scale_sd = vals_r__[pos__++];
            current_statement_begin__ = 360;
            context__.validate_dims("data initialization", "obs_weight", "double", context__.to_vec());
            obs_weight = double(0);
            vals_r__ = context__.vals_r("obs_weight");
            pos__ = 0;
            obs_weight = vals_r__[pos__++];
            current_statement_begin__ = 361;
            context__.validate_dims("data initialization", "likelihood", "int", context__.to_vec());
            likelihood = int(0);
            vals_i__ = context__.vals_i("likelihood");
            pos__ = 0;
            likelihood = vals_i__[pos__++];
            current_statement_begin__ = 362;
            context__.validate_dims("data initialization", "return_likelihood", "int", context__.to_vec());
            return_likelihood = int(0);
            vals_i__ = context__.vals_i("return_likelihood");
            pos__ = 0;
            return_likelihood = vals_i__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 366;
            delay_max_fixed = int(0);
            stan::math::fill(delay_max_fixed, std::numeric_limits<int>::min());
            stan::math::assign(delay_max_fixed,(logical_eq(n_fixed_delays, 0) ? 0 : ((sum(stan::model::rvalue(delay_max, stan::model::cons_list(stan::model::index_multi(fixed_delays), stan::model::nil_index_list()), "delay_max")) - num_elements(fixed_delays)) + 1) ));
            current_statement_begin__ = 368;
            delay_max_total = int(0);
            stan::math::fill(delay_max_total, std::numeric_limits<int>::min());
            stan::math::assign(delay_max_total,(logical_eq(delays, 0) ? 0 : ((sum(delay_max) - num_elements(delay_max)) + 1) ));
            current_statement_begin__ = 370;
            validate_non_negative_index("trunc_fixed_pmf", "((primitive_value(truncation) && primitive_value(get_base1(trunc_fixed, 1, \"trunc_fixed\", 1))) ? get_base1(trunc_max, 1, \"trunc_max\", 1) : 0 )", ((primitive_value(truncation) && primitive_value(get_base1(trunc_fixed, 1, "trunc_fixed", 1))) ? get_base1(trunc_max, 1, "trunc_max", 1) : 0 ));
            trunc_fixed_pmf = Eigen::Matrix<double, Eigen::Dynamic, 1>(((primitive_value(truncation) && primitive_value(get_base1(trunc_fixed, 1, "trunc_fixed", 1))) ? get_base1(trunc_max, 1, "trunc_max", 1) : 0 ));
            stan::math::fill(trunc_fixed_pmf, DUMMY_VAR__);
            current_statement_begin__ = 371;
            validate_non_negative_index("delays_fixed_pmf", "delay_max_fixed", delay_max_fixed);
            delays_fixed_pmf = Eigen::Matrix<double, Eigen::Dynamic, 1>(delay_max_fixed);
            stan::math::fill(delays_fixed_pmf, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 373;
            if (as_bool((primitive_value(truncation) && primitive_value(get_base1(trunc_fixed, 1, "trunc_fixed", 1))))) {
                current_statement_begin__ = 374;
                stan::math::assign(trunc_fixed_pmf, discretised_pmf(get_base1(trunc_mean_mean, 1, "trunc_mean_mean", 1), get_base1(trunc_sd_mean, 1, "trunc_sd_mean", 1), get_base1(trunc_max, 1, "trunc_max", 1), get_base1(trunc_dist, 1, "trunc_dist", 1), 0, pstream__));
            }
            current_statement_begin__ = 378;
            if (as_bool(n_fixed_delays)) {
                current_statement_begin__ = 379;
                stan::math::assign(delays_fixed_pmf, combine_pmfs(to_vector(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).array())), stan::model::rvalue(delay_mean_mean, stan::model::cons_list(stan::model::index_multi(fixed_delays), stan::model::nil_index_list()), "delay_mean_mean"), stan::model::rvalue(delay_sd_mean, stan::model::cons_list(stan::model::index_multi(fixed_delays), stan::model::nil_index_list()), "delay_sd_mean"), stan::model::rvalue(delay_max, stan::model::cons_list(stan::model::index_multi(fixed_delays), stan::model::nil_index_list()), "delay_max"), stan::model::rvalue(delay_dist, stan::model::cons_list(stan::model::index_multi(fixed_delays), stan::model::nil_index_list()), "delay_dist"), delay_max_fixed, 0, 0, pstream__));
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 389;
            validate_non_negative_index("delay_mean", "n_uncertain_mean_delays", n_uncertain_mean_delays);
            num_params_r__ += (1 * n_uncertain_mean_delays);
            current_statement_begin__ = 390;
            validate_non_negative_index("delay_sd", "n_uncertain_sd_delays", n_uncertain_sd_delays);
            num_params_r__ += (1 * n_uncertain_sd_delays);
            current_statement_begin__ = 391;
            validate_non_negative_index("day_of_week_simplex", "week_effect", week_effect);
            num_params_r__ += (week_effect - 1);
            current_statement_begin__ = 392;
            validate_non_negative_index("frac_obs", "obs_scale", obs_scale);
            num_params_r__ += (1 * obs_scale);
            current_statement_begin__ = 393;
            validate_non_negative_index("trunc_mean", "(primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, \"trunc_fixed\", 1))))", (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
            num_params_r__ += (1 * (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
            current_statement_begin__ = 394;
            validate_non_negative_index("trunc_sd", "(primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, \"trunc_fixed\", 1))))", (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
            num_params_r__ += (1 * (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
            current_statement_begin__ = 395;
            validate_non_negative_index("rep_phi", "model_type", model_type);
            num_params_r__ += (1 * model_type);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_estimate_secondary() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 389;
        if (!(context__.contains_r("delay_mean")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delay_mean missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delay_mean");
        pos__ = 0U;
        validate_non_negative_index("delay_mean", "n_uncertain_mean_delays", n_uncertain_mean_delays);
        context__.validate_dims("parameter initialization", "delay_mean", "double", context__.to_vec(n_uncertain_mean_delays));
        std::vector<double> delay_mean(n_uncertain_mean_delays, double(0));
        size_t delay_mean_k_0_max__ = n_uncertain_mean_delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            delay_mean[k_0__] = vals_r__[pos__++];
        }
        size_t delay_mean_i_0_max__ = n_uncertain_mean_delays;
        for (size_t i_0__ = 0; i_0__ < delay_mean_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(delay_mean[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delay_mean: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 390;
        if (!(context__.contains_r("delay_sd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delay_sd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delay_sd");
        pos__ = 0U;
        validate_non_negative_index("delay_sd", "n_uncertain_sd_delays", n_uncertain_sd_delays);
        context__.validate_dims("parameter initialization", "delay_sd", "double", context__.to_vec(n_uncertain_sd_delays));
        std::vector<double> delay_sd(n_uncertain_sd_delays, double(0));
        size_t delay_sd_k_0_max__ = n_uncertain_sd_delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            delay_sd[k_0__] = vals_r__[pos__++];
        }
        size_t delay_sd_i_0_max__ = n_uncertain_sd_delays;
        for (size_t i_0__ = 0; i_0__ < delay_sd_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, delay_sd[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delay_sd: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 391;
        if (!(context__.contains_r("day_of_week_simplex")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable day_of_week_simplex missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("day_of_week_simplex");
        pos__ = 0U;
        validate_non_negative_index("day_of_week_simplex", "week_effect", week_effect);
        context__.validate_dims("parameter initialization", "day_of_week_simplex", "vector_d", context__.to_vec(week_effect));
        Eigen::Matrix<double, Eigen::Dynamic, 1> day_of_week_simplex(week_effect);
        size_t day_of_week_simplex_j_1_max__ = week_effect;
        for (size_t j_1__ = 0; j_1__ < day_of_week_simplex_j_1_max__; ++j_1__) {
            day_of_week_simplex(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.simplex_unconstrain(day_of_week_simplex);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable day_of_week_simplex: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 392;
        if (!(context__.contains_r("frac_obs")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable frac_obs missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("frac_obs");
        pos__ = 0U;
        validate_non_negative_index("frac_obs", "obs_scale", obs_scale);
        context__.validate_dims("parameter initialization", "frac_obs", "double", context__.to_vec(obs_scale));
        std::vector<double> frac_obs(obs_scale, double(0));
        size_t frac_obs_k_0_max__ = obs_scale;
        for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
            frac_obs[k_0__] = vals_r__[pos__++];
        }
        size_t frac_obs_i_0_max__ = obs_scale;
        for (size_t i_0__ = 0; i_0__ < frac_obs_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(0, 1, frac_obs[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable frac_obs: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 393;
        if (!(context__.contains_r("trunc_mean")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable trunc_mean missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("trunc_mean");
        pos__ = 0U;
        validate_non_negative_index("trunc_mean", "(primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, \"trunc_fixed\", 1))))", (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
        context__.validate_dims("parameter initialization", "trunc_mean", "double", context__.to_vec((primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))))));
        std::vector<double> trunc_mean((primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))), double(0));
        size_t trunc_mean_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_mean_k_0_max__; ++k_0__) {
            trunc_mean[k_0__] = vals_r__[pos__++];
        }
        size_t trunc_mean_i_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t i_0__ = 0; i_0__ < trunc_mean_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(trunc_mean[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable trunc_mean: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 394;
        if (!(context__.contains_r("trunc_sd")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable trunc_sd missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("trunc_sd");
        pos__ = 0U;
        validate_non_negative_index("trunc_sd", "(primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, \"trunc_fixed\", 1))))", (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
        context__.validate_dims("parameter initialization", "trunc_sd", "double", context__.to_vec((primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))))));
        std::vector<double> trunc_sd((primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))), double(0));
        size_t trunc_sd_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_sd_k_0_max__; ++k_0__) {
            trunc_sd[k_0__] = vals_r__[pos__++];
        }
        size_t trunc_sd_i_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t i_0__ = 0; i_0__ < trunc_sd_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(trunc_sd[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable trunc_sd: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 395;
        if (!(context__.contains_r("rep_phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rep_phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rep_phi");
        pos__ = 0U;
        validate_non_negative_index("rep_phi", "model_type", model_type);
        context__.validate_dims("parameter initialization", "rep_phi", "double", context__.to_vec(model_type));
        std::vector<double> rep_phi(model_type, double(0));
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            rep_phi[k_0__] = vals_r__[pos__++];
        }
        size_t rep_phi_i_0_max__ = model_type;
        for (size_t i_0__ = 0; i_0__ < rep_phi_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, rep_phi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rep_phi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 389;
            std::vector<local_scalar_t__> delay_mean;
            size_t delay_mean_d_0_max__ = n_uncertain_mean_delays;
            delay_mean.reserve(delay_mean_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < delay_mean_d_0_max__; ++d_0__) {
                if (jacobian__)
                    delay_mean.push_back(in__.scalar_constrain(lp__));
                else
                    delay_mean.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 390;
            std::vector<local_scalar_t__> delay_sd;
            size_t delay_sd_d_0_max__ = n_uncertain_sd_delays;
            delay_sd.reserve(delay_sd_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < delay_sd_d_0_max__; ++d_0__) {
                if (jacobian__)
                    delay_sd.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    delay_sd.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 391;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> day_of_week_simplex;
            (void) day_of_week_simplex;  // dummy to suppress unused var warning
            if (jacobian__)
                day_of_week_simplex = in__.simplex_constrain(week_effect, lp__);
            else
                day_of_week_simplex = in__.simplex_constrain(week_effect);
            current_statement_begin__ = 392;
            std::vector<local_scalar_t__> frac_obs;
            size_t frac_obs_d_0_max__ = obs_scale;
            frac_obs.reserve(frac_obs_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < frac_obs_d_0_max__; ++d_0__) {
                if (jacobian__)
                    frac_obs.push_back(in__.scalar_lub_constrain(0, 1, lp__));
                else
                    frac_obs.push_back(in__.scalar_lub_constrain(0, 1));
            }
            current_statement_begin__ = 393;
            std::vector<local_scalar_t__> trunc_mean;
            size_t trunc_mean_d_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
            trunc_mean.reserve(trunc_mean_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < trunc_mean_d_0_max__; ++d_0__) {
                if (jacobian__)
                    trunc_mean.push_back(in__.scalar_constrain(lp__));
                else
                    trunc_mean.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 394;
            std::vector<local_scalar_t__> trunc_sd;
            size_t trunc_sd_d_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
            trunc_sd.reserve(trunc_sd_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < trunc_sd_d_0_max__; ++d_0__) {
                if (jacobian__)
                    trunc_sd.push_back(in__.scalar_constrain(lp__));
                else
                    trunc_sd.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 395;
            std::vector<local_scalar_t__> rep_phi;
            size_t rep_phi_d_0_max__ = model_type;
            rep_phi.reserve(rep_phi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rep_phi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rep_phi.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    rep_phi.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 399;
            validate_non_negative_index("secondary", "t", t);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> secondary(t);
            stan::math::initialize(secondary, DUMMY_VAR__);
            stan::math::fill(secondary, DUMMY_VAR__);
            // transformed parameters block statements
            {
            current_statement_begin__ = 403;
            validate_non_negative_index("delay_rev_pmf", "delay_max_total", delay_max_total);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delay_rev_pmf(delay_max_total);
            stan::math::initialize(delay_rev_pmf, DUMMY_VAR__);
            stan::math::fill(delay_rev_pmf, DUMMY_VAR__);
            current_statement_begin__ = 404;
            stan::math::assign(delay_rev_pmf, combine_pmfs(delays_fixed_pmf, delay_mean, delay_sd, delay_max, delay_dist, delay_max_total, 0, 1, pstream__));
            current_statement_begin__ = 407;
            stan::math::assign(secondary, calculate_secondary(primary, obs, frac_obs, delay_rev_pmf, cumulative, historic, primary_hist_additive, current, primary_current_additive, t, pstream__));
            }
            current_statement_begin__ = 414;
            if (as_bool(logical_gt(week_effect, 1))) {
                current_statement_begin__ = 415;
                stan::math::assign(secondary, day_of_week_effect(secondary, day_of_week, day_of_week_simplex, pstream__));
            }
            current_statement_begin__ = 418;
            if (as_bool(truncation)) {
                {
                current_statement_begin__ = 419;
                validate_non_negative_index("trunc_rev_cmf", "get_base1(trunc_max, 1, \"trunc_max\", 1)", get_base1(trunc_max, 1, "trunc_max", 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_rev_cmf(get_base1(trunc_max, 1, "trunc_max", 1));
                stan::math::initialize(trunc_rev_cmf, DUMMY_VAR__);
                stan::math::fill(trunc_rev_cmf, DUMMY_VAR__);
                current_statement_begin__ = 420;
                stan::math::assign(trunc_rev_cmf, reverse_mf(cumulative_sum(combine_pmfs(trunc_fixed_pmf, trunc_mean, trunc_sd, trunc_max, trunc_dist, get_base1(trunc_max, 1, "trunc_max", 1), 0, 0, pstream__)), pstream__));
                current_statement_begin__ = 423;
                stan::math::assign(secondary, truncate(secondary, trunc_rev_cmf, 0, pstream__));
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 399;
            size_t secondary_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < secondary_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(secondary(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: secondary" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable secondary: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "secondary", secondary, 0);
            // model body
            current_statement_begin__ = 429;
            delays_lp(delay_mean, stan::model::rvalue(delay_mean_mean, stan::model::cons_list(stan::model::index_multi(uncertain_mean_delays), stan::model::nil_index_list()), "delay_mean_mean"), stan::model::rvalue(delay_mean_sd, stan::model::cons_list(stan::model::index_multi(uncertain_mean_delays), stan::model::nil_index_list()), "delay_mean_sd"), delay_sd, stan::model::rvalue(delay_sd_mean, stan::model::cons_list(stan::model::index_multi(uncertain_sd_delays), stan::model::nil_index_list()), "delay_sd_mean"), stan::model::rvalue(delay_sd_sd, stan::model::cons_list(stan::model::index_multi(uncertain_sd_delays), stan::model::nil_index_list()), "delay_sd_sd"), stan::model::rvalue(delay_dist, stan::model::cons_list(stan::model::index_multi(uncertain_mean_delays), stan::model::nil_index_list()), "delay_dist"), t, lp__, lp_accum__, pstream__);
            current_statement_begin__ = 437;
            delays_lp(trunc_mean, trunc_sd, trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, trunc_dist, 1, lp__, lp_accum__, pstream__);
            current_statement_begin__ = 440;
            if (as_bool(obs_scale)) {
                current_statement_begin__ = 441;
                lp_accum__.add(normal_log<propto__>(get_base1(frac_obs, 1, "frac_obs", 1), obs_scale_mean, obs_scale_sd));
                if (get_base1(frac_obs, 1, "frac_obs", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else if (get_base1(frac_obs, 1, "frac_obs", 1) > 1) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-log_diff_exp(normal_cdf_log(1, obs_scale_mean, obs_scale_sd), normal_cdf_log(0, obs_scale_mean, obs_scale_sd)));
            }
            current_statement_begin__ = 444;
            if (as_bool(likelihood)) {
                current_statement_begin__ = 445;
                report_lp(stan::model::rvalue(obs, stan::model::cons_list(stan::model::index_min_max((burn_in + 1), t), stan::model::nil_index_list()), "obs"), stan::model::rvalue(secondary, stan::model::cons_list(stan::model::index_min_max((burn_in + 1), t), stan::model::nil_index_list()), "secondary"), rep_phi, phi_mean, phi_sd, model_type, 1, lp__, lp_accum__, pstream__);
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("delay_mean");
        names__.push_back("delay_sd");
        names__.push_back("day_of_week_simplex");
        names__.push_back("frac_obs");
        names__.push_back("trunc_mean");
        names__.push_back("trunc_sd");
        names__.push_back("rep_phi");
        names__.push_back("secondary");
        names__.push_back("sim_secondary");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_uncertain_mean_delays);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_uncertain_sd_delays);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(week_effect);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(obs_scale);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1)))));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(model_type);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(t);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((t - burn_in));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_estimate_secondary_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> delay_mean;
        size_t delay_mean_d_0_max__ = n_uncertain_mean_delays;
        delay_mean.reserve(delay_mean_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < delay_mean_d_0_max__; ++d_0__) {
            delay_mean.push_back(in__.scalar_constrain());
        }
        size_t delay_mean_k_0_max__ = n_uncertain_mean_delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            vars__.push_back(delay_mean[k_0__]);
        }
        std::vector<double> delay_sd;
        size_t delay_sd_d_0_max__ = n_uncertain_sd_delays;
        delay_sd.reserve(delay_sd_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < delay_sd_d_0_max__; ++d_0__) {
            delay_sd.push_back(in__.scalar_lb_constrain(0));
        }
        size_t delay_sd_k_0_max__ = n_uncertain_sd_delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            vars__.push_back(delay_sd[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> day_of_week_simplex = in__.simplex_constrain(week_effect);
        size_t day_of_week_simplex_j_1_max__ = week_effect;
        for (size_t j_1__ = 0; j_1__ < day_of_week_simplex_j_1_max__; ++j_1__) {
            vars__.push_back(day_of_week_simplex(j_1__));
        }
        std::vector<double> frac_obs;
        size_t frac_obs_d_0_max__ = obs_scale;
        frac_obs.reserve(frac_obs_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < frac_obs_d_0_max__; ++d_0__) {
            frac_obs.push_back(in__.scalar_lub_constrain(0, 1));
        }
        size_t frac_obs_k_0_max__ = obs_scale;
        for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
            vars__.push_back(frac_obs[k_0__]);
        }
        std::vector<double> trunc_mean;
        size_t trunc_mean_d_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        trunc_mean.reserve(trunc_mean_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < trunc_mean_d_0_max__; ++d_0__) {
            trunc_mean.push_back(in__.scalar_constrain());
        }
        size_t trunc_mean_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_mean_k_0_max__; ++k_0__) {
            vars__.push_back(trunc_mean[k_0__]);
        }
        std::vector<double> trunc_sd;
        size_t trunc_sd_d_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        trunc_sd.reserve(trunc_sd_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < trunc_sd_d_0_max__; ++d_0__) {
            trunc_sd.push_back(in__.scalar_constrain());
        }
        size_t trunc_sd_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_sd_k_0_max__; ++k_0__) {
            vars__.push_back(trunc_sd[k_0__]);
        }
        std::vector<double> rep_phi;
        size_t rep_phi_d_0_max__ = model_type;
        rep_phi.reserve(rep_phi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rep_phi_d_0_max__; ++d_0__) {
            rep_phi.push_back(in__.scalar_lb_constrain(0));
        }
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            vars__.push_back(rep_phi[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 399;
            validate_non_negative_index("secondary", "t", t);
            Eigen::Matrix<double, Eigen::Dynamic, 1> secondary(t);
            stan::math::initialize(secondary, DUMMY_VAR__);
            stan::math::fill(secondary, DUMMY_VAR__);
            // do transformed parameters statements
            {
            current_statement_begin__ = 403;
            validate_non_negative_index("delay_rev_pmf", "delay_max_total", delay_max_total);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> delay_rev_pmf(delay_max_total);
            stan::math::initialize(delay_rev_pmf, DUMMY_VAR__);
            stan::math::fill(delay_rev_pmf, DUMMY_VAR__);
            current_statement_begin__ = 404;
            stan::math::assign(delay_rev_pmf, combine_pmfs(delays_fixed_pmf, delay_mean, delay_sd, delay_max, delay_dist, delay_max_total, 0, 1, pstream__));
            current_statement_begin__ = 407;
            stan::math::assign(secondary, calculate_secondary(primary, obs, frac_obs, delay_rev_pmf, cumulative, historic, primary_hist_additive, current, primary_current_additive, t, pstream__));
            }
            current_statement_begin__ = 414;
            if (as_bool(logical_gt(week_effect, 1))) {
                current_statement_begin__ = 415;
                stan::math::assign(secondary, day_of_week_effect(secondary, day_of_week, day_of_week_simplex, pstream__));
            }
            current_statement_begin__ = 418;
            if (as_bool(truncation)) {
                {
                current_statement_begin__ = 419;
                validate_non_negative_index("trunc_rev_cmf", "get_base1(trunc_max, 1, \"trunc_max\", 1)", get_base1(trunc_max, 1, "trunc_max", 1));
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> trunc_rev_cmf(get_base1(trunc_max, 1, "trunc_max", 1));
                stan::math::initialize(trunc_rev_cmf, DUMMY_VAR__);
                stan::math::fill(trunc_rev_cmf, DUMMY_VAR__);
                current_statement_begin__ = 420;
                stan::math::assign(trunc_rev_cmf, reverse_mf(cumulative_sum(combine_pmfs(trunc_fixed_pmf, trunc_mean, trunc_sd, trunc_max, trunc_dist, get_base1(trunc_max, 1, "trunc_max", 1), 0, 0, pstream__)), pstream__));
                current_statement_begin__ = 423;
                stan::math::assign(secondary, truncate(secondary, trunc_rev_cmf, 0, pstream__));
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 399;
            check_greater_or_equal(function__, "secondary", secondary, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t secondary_j_1_max__ = t;
                for (size_t j_1__ = 0; j_1__ < secondary_j_1_max__; ++j_1__) {
                    vars__.push_back(secondary(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 451;
            validate_non_negative_index("sim_secondary", "(t - burn_in)", (t - burn_in));
            std::vector<int> sim_secondary((t - burn_in), int(0));
            stan::math::fill(sim_secondary, std::numeric_limits<int>::min());
            current_statement_begin__ = 452;
            validate_non_negative_index("log_lik", "(logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 )", (logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik((logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 ));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 454;
            stan::math::assign(sim_secondary, report_rng(stan::model::rvalue(secondary, stan::model::cons_list(stan::model::index_min_max((burn_in + 1), t), stan::model::nil_index_list()), "secondary"), rep_phi, model_type, base_rng__, pstream__));
            current_statement_begin__ = 456;
            if (as_bool(return_likelihood)) {
                current_statement_begin__ = 457;
                stan::math::assign(log_lik, report_log_lik(stan::model::rvalue(obs, stan::model::cons_list(stan::model::index_min_max((burn_in + 1), t), stan::model::nil_index_list()), "obs"), stan::model::rvalue(secondary, stan::model::cons_list(stan::model::index_min_max((burn_in + 1), t), stan::model::nil_index_list()), "secondary"), rep_phi, model_type, obs_weight, pstream__));
            }
            // validate, write generated quantities
            current_statement_begin__ = 451;
            size_t sim_secondary_k_0_max__ = (t - burn_in);
            for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
                vars__.push_back(sim_secondary[k_0__]);
            }
            current_statement_begin__ = 452;
            size_t log_lik_j_1_max__ = (logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 );
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_estimate_secondary";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t delay_mean_k_0_max__ = n_uncertain_mean_delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delay_sd_k_0_max__ = n_uncertain_sd_delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t day_of_week_simplex_j_1_max__ = week_effect;
        for (size_t j_1__ = 0; j_1__ < day_of_week_simplex_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "day_of_week_simplex" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t frac_obs_k_0_max__ = obs_scale;
        for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "frac_obs" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t trunc_mean_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trunc_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t trunc_sd_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trunc_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rep_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t secondary_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < secondary_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "secondary" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t sim_secondary_k_0_max__ = (t - burn_in);
        for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_secondary" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = (logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 );
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t delay_mean_k_0_max__ = n_uncertain_mean_delays;
        for (size_t k_0__ = 0; k_0__ < delay_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delay_sd_k_0_max__ = n_uncertain_sd_delays;
        for (size_t k_0__ = 0; k_0__ < delay_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delay_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t day_of_week_simplex_j_1_max__ = (week_effect - 1);
        for (size_t j_1__ = 0; j_1__ < day_of_week_simplex_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "day_of_week_simplex" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t frac_obs_k_0_max__ = obs_scale;
        for (size_t k_0__ = 0; k_0__ < frac_obs_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "frac_obs" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t trunc_mean_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_mean_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trunc_mean" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t trunc_sd_k_0_max__ = (primitive_value(truncation) && primitive_value(logical_negation(get_base1(trunc_fixed, 1, "trunc_fixed", 1))));
        for (size_t k_0__ = 0; k_0__ < trunc_sd_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "trunc_sd" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rep_phi_k_0_max__ = model_type;
        for (size_t k_0__ = 0; k_0__ < rep_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rep_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t secondary_j_1_max__ = t;
            for (size_t j_1__ = 0; j_1__ < secondary_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "secondary" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t sim_secondary_k_0_max__ = (t - burn_in);
        for (size_t k_0__ = 0; k_0__ < sim_secondary_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_secondary" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = (logical_gt(return_likelihood, 1) ? (t - burn_in) : 0 );
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_estimate_secondary_namespace::model_estimate_secondary stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
