% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_estimates}
\alias{plot_estimates}
\title{Plot Estimates}
\usage{
plot_estimates(
  estimate,
  reported,
  ylab = "Cases",
  hline,
  obs_as_col = TRUE,
  max_plot = 10
)
}
\arguments{
\item{estimate}{A data.table of estimates containing the following variables: date, type
(must contain "estimate", "estimate based on partial data" and optionally "forecast"),}

\item{reported}{A data.table of reported cases with the following variables: date, confirm.}

\item{ylab}{Character string, defaulting to "Cases". Title for the plot y axis.}

\item{hline}{Numeric, if supplied gives the horizontal intercept for a indicator line.}

\item{obs_as_col}{Logical, defaults to \code{TRUE}. Should observed data, if supplied, be plotted using columns or
as points (linked using a line).}

\item{max_plot}{Numeric, defaults to 10. A multiplicative upper bound on the number of cases shown on the plot. Based
on the maximum number of reported cases.}
}
\value{
A \code{ggplot2} object
}
\description{
Plot Estimates
}
\examples{
\donttest{
# define example cases
cases <- EpiNow2::example_confirmed[1:40]

# set up example delays
generation_time <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
incubation_period <- get_incubation_period(disease = "SARS-CoV-2", source = "lauer")
reporting_delay <- EpiNow2::bootstrapped_dist_fit(rlnorm(100, log(6), 1), max_value = 30)

                        
# run model
out <- EpiNow2::estimate_infections(cases, generation_time = generation_time,
                                    delays = list(incubation_period, reporting_delay),
                                    stan_args = list(cores = ifelse(interactive(), 4, 1)))
# plot infections
plot_estimates(
  estimate = out$summarised[variable == "infections"],
  reported = cases,
  ylab = "Cases", max_plot = 2) + ggplot2::facet_wrap(~type, scales = "free_y")

# plot reported cases estimated via Rt
plot_estimates(estimate = out$summarised[variable == "reported_cases"],
               reported = cases,
               ylab = "Cases")
               
# plot Rt estimates
plot_estimates(estimate = out$summarised[variable == "R"],
               ylab = "Effective Reproduction No.",
               hline = 1)
}
}
