% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{country_map}
\alias{country_map}
\title{Generate a country map for a single variable.}
\usage{
country_map(
  data = NULL,
  country = NULL,
  variable = NULL,
  variable_label = NULL,
  trans = "identity",
  fill_labels = NULL,
  scale_fill = NULL,
  region_col_ne = "provnum_ne",
  ...
)
}
\arguments{
\item{data}{Dataframe containing variables to be mapped. Must contain a \code{region_code} variable.}

\item{country}{Character string indicating the name of the country to be mapped.}

\item{variable}{A character string indicating the variable to map data for. This must be supplied.}

\item{variable_label}{A character string indicating the variable label to use. If not supplied then the underlying
variable name is used.}

\item{trans}{A character string specifying the transform to use on the specified metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{fill_labels}{A function to use to allocate legend labels. An example (used below) is \code{scales::percent},
which can be used for percentage data.}

\item{scale_fill}{Function to use for scaling the fill. Defaults to a custom \code{ggplot2::scale_fill_manual}, which
expects the possible values to be "Increasing", "Likely increasing", "Likely decreasing", "Decreasing" or "Unsure".}

\item{region_col_ne}{Character string indicating the name of a column in the data returned by
\code{rnaturalearth::ne_states()} that \code{data$region_code} corresponds to. Possibilities include
\code{provnum_ne}, \code{name}, \code{fips} and others and will depend on which country you are mapping.}

\item{...}{Additional arguments passed to the \code{scale_fill} function}
}
\value{
A \code{ggplot2} object containing a country map.
}
\description{
This general purpose function can be used to generate a country map for a single variable. It has few defaults but
the data supplied must contain a \code{region_code} variable for linking to mapping data. This function requires
the installation of the \code{rnaturalearth} package.
}
\examples{
\donttest{
if(requireNamespace("rnaturalearth") & requireNamespace("scales")){
# Example 1
# if you know the provnum_ne codes you can use them directly
eg_data <- data.table::data.table(variable = c("Increasing", 
                                               "Decreasing", 
                                               "Unsure", 
                                               "Likely decreasing",
                                               "Likely increasing"),
                                  region_code = c(5, 7, 6, 8, 9))
# make variable a factor so the ordering is sensible
eg_data$variable <- factor(eg_data$variable, levels = c("Decreasing", "Likely decreasing",
                                                        "Unsure", "Likely increasing",
                                                        "Increasing"))

country_map(data = eg_data, country = "Australia", variable = "variable")


# Example 2
# sometimes it will be more convenient to join your data by name than provnum_ne code:
us_data <- data.table::data.table(variable = c("Increasing", 
                                               "Decreasing", 
                                               "Unsure", 
                                               "Likely decreasing",
                                               "Likely increasing"),
                                  region_code = c("California",
                                                  "Texas",
                                                  "Florida",
                                                  "Arizona",
                                                  "New York"))
# make variable a factor so the ordering is sensible in the legend
us_data$variable <- factor(us_data$variable, levels = c("Decreasing", "Likely decreasing",
                                                        "Unsure", "Likely increasing",
                                                        "Increasing"))

country_map(data = us_data, country = "United States of America",
            variable = "variable", region_col_ne = "name")
}
}
}
