% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_plots}
\alias{report_plots}
\title{Report plots}
\usage{
report_plots(summarised_estimates, reported, target_folder, max_plot = 10)
}
\arguments{
\item{summarised_estimates}{A data.table of summarised estimates containing the following variables:
variable, median, bottom, and top. It should contain the following estimates: R, infections, reported_cases_rt,
and r (rate of growth).}

\item{reported}{A data.table of reported cases with the following variables: date, confirm.}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{max_plot}{Numeric, defaults to 10. A multiplicative upper bound on the number of cases shown on the plot. Based
on the maximum number of reported cases.}
}
\value{
A \code{ggplot2} object
}
\description{
Report plots
}
\examples{
\donttest{
## Define example cases
cases <- EpiNow2::example_confirmed[1:40]

 
## Set up example generation time
generation_time <- list(mean = EpiNow2::covid_generation_times[1, ]$mean,
                        mean_sd = EpiNow2::covid_generation_times[1, ]$mean_sd,
                        sd = EpiNow2::covid_generation_times[1, ]$sd,
                        sd_sd = EpiNow2::covid_generation_times[1, ]$sd_sd,
                        max = 30)
## Set                   
incubation_period <- list(mean = EpiNow2::covid_incubation_period[1, ]$mean,
                          mean_sd = EpiNow2::covid_incubation_period[1, ]$mean_sd,
                          sd = EpiNow2::covid_incubation_period[1, ]$sd,
                          sd_sd = EpiNow2::covid_incubation_period[1, ]$sd_sd,
                          max = 30)
                   
reporting_delay <- list(mean = log(5),
                        mean_sd = log(2),
                        sd = log(2),
                        sd_sd = log(1.5),
                        max = 30)
                        
## Run model
out <- EpiNow2::estimate_infections(cases, family = "negbin",
                                    generation_time = generation_time,
                                    delays = list(incubation_period, reporting_delay),
                                    samples = 1000, warmup = 200, cores = 4, chains = 4,
                                    horizon = 7, estimate_rt = TRUE, verbose = TRUE)
                            
                     
## Plot infections
plots <- report_plots(summarised_estimates = out$summarised,
                      reported = cases)
                      
plots
}
}
