% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SISDemogStoch}
\alias{SISDemogStoch}
\title{SIS model with demographic stochasticity (P 6.3).}
\usage{
SISDemogStoch(pars, init, end.time)
}
\arguments{
\item{pars}{\code{\link{vector}} with 3 values: the transmission and recovery rates and the population size assumed to be constant. The names of these values must be "beta", "gamma", and "N" respectively.}

\item{init}{initial number of infectious.}

\item{end.time}{end time to be simulated.}
}
\value{
\code{\link{list}}. The first three elements are the vectors \code{*$pars}, \code{*$init} and \code{*$time}, containing the \code{pars}, \code{init} and \code{end.time} arguments of the function. The fourth element \code{*$results} is a \code{\link{data.frame}} with up to as many rows as time steps created during the stochastic simulations. The second column contains the number of infectious.
}
\description{
SIS model with event-driven or demographic stochasticity.
}
\details{
This is the R version of program 6.3 from page 202 of "Modeling Infectious Disease in humans and animals" by Keeling & Rohani.
}
\examples{
# Parameters and initial conditions.
parameters <- c(beta = 0.03, gamma = 1 / 100, N = 100)
initials <- 70

# Solve and plot.
sis.demog.stoch <- SISDemogStoch(pars = parameters,
                                 init = initials, end.time = 10 * 365)
PlotMods(sis.demog.stoch)
}
\references{
Keeling, Matt J., and Pejman Rohani. Modeling infectious diseases in humans and animals. Princeton University Press, 2008.
\href{http://www.modelinginfectiousdiseases.org/}{Modeling Infectious Diseases in Humans and Animals}
}

