% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individuals.r
\name{individuals}
\alias{individuals}
\title{individuals present in the group}
\usage{
individuals(eloobject, from = eloobject$misc["maxDate"], to = NULL,
  outp = c("N", "IDs", "CV"))
}
\arguments{
\item{eloobject}{result from \code{\link{elo.seq}}}

\item{from}{character, from which date onwards should the ID statistics be calculated. By default the first date in the sequence is used}

\item{to}{character, until which date should the ID statistics be calculated. By default \code{NULL}, i.e. the returned information refers to only the date specified by \code{from}}

\item{outp}{character, one of three options to determine which kind of information is returned: (1) \code{"N"}: the (average) number of individuals present, (2) \code{"IDs"}: the actual IDs, and (3): \code{"CV"}: coefficient of number of individuals present}
}
\value{
numeric or character
}
\description{
returns IDs, number or IDs, or CV of number of present individuals
}
\details{
if \code{to=NULL}, either the IDs (\code{outp="IDs"}) or the number of individuals (\code{outp="N"}) present on this day is returned. \code{outp="CV"} is not defined in such a case (returns \code{NA}).

if a \code{to} date is set (i.e. different from \code{NULL}), either the IDs of all individuals that were present on at least one day of the date range (\code{outp="IDs"}) is returned or the average number of individuals present during this time (\code{outp="N"}). If \code{outp="CV"}, the coefficient of variation of the number of individuals present is returned, which might be considererd another measure of stability on the group level.
}
\examples{
data(adv)
SEQ <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date)
individuals(SEQ, outp = "N")
individuals(SEQ, outp = "IDs")
individuals(SEQ, outp = "CV") # not defined

# consider additional presence information
data(advpres)
SEQ <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date,
               presence = advpres)
individuals(SEQ, outp = "N")
individuals(SEQ, outp = "IDs")
individuals(SEQ, outp = "CV") # not defined

# across a date range
individuals(SEQ, from = "2010-01-01", to = "2010-01-31", outp = "N")
individuals(SEQ, from = "2010-01-01", to = "2010-01-31", outp = "IDs")
individuals(SEQ, from = "2010-01-01", to = "2010-01-31", outp = "CV")
}
\author{
Christof Neumann
}
