% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.sdf.R
\name{recode.sdf}
\alias{recode.sdf}
\title{Recode Levels Within Variables}
\usage{
recode.sdf(x, recode)
}
\arguments{
\item{x}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, 
or an \code{edsurvey.data.frame.list}.}

\item{recode}{a list of recoding rules. See Examples for the format of recoding rules.}
}
\value{
an object of the same class as \code{x} with the recode added to it
}
\description{
Recodes variables in an \code{edsurvey.data.frame}, 
             a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
}
\examples{
\dontrun{
usaG4.15 <- readTIMSS("C:/TIMSS2015", "usa", 4)
d <- getData(usaG4.15, "itsex")
summary(d) #show details: MALE/FEMALE
usaG4.15 <- recode.sdf(usaG4.15, recode = list(itsex=list(from=c("MALE"),
                                              to=c("BOY")),
                                   itsex=list(from=c("FEMALE"),
                                              to=c("GIRL"))))

d <- getData(usaG4.15, "itsex") #apply recode
summary(d) #show details: BOY/GIRL
}
}
\author{
Trang Nguyen and Paul Bailey
}
