% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{clustergram.kmeans}
\alias{clustergram.kmeans}
\title{Type function that clustergram takes for clustering.}
\usage{
clustergram.kmeans(Data, k, ...)
}
\arguments{
\item{Data}{Should be a scales matrix. Where each column belongs to a
different dimension of the observations}

\item{k}{Number of desired groups for the k-means clustering.}

\item{...}{Additional parameters to be passed in the kmeans function (from
the stats package).}
}
\value{
A list containing the cluster vector and the centers matrix (see
  kmeans function).
}
\description{
Type function that clustergram takes for clustering.
}
\details{
This is the type of function that the clustergram function uses for
  clustering. The return list is internally used by the clustergram to build
  the clustergram plot.
}
\examples{
  ####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## 6 clustergram plots
   for (i in 1:6) clustergram(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                              clustering.function = clustergram.kmeans,
                              k.range = 2:10, line.width = .2)

}
