% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.getisord.R
\name{eco.getisord}
\alias{eco.getisord}
\title{Local Getis-Ord's G and G* for analysis of hot spots}
\usage{
eco.getisord(z, con, zerocon = NA, classG = c("G", "G*"), nsim = 99,
  test = c("permutation", "bootstrap"), alternative = c("auto", "two.sided",
  "greater", "less"), adjust = c("fdr", "holm", "hochberg", "hommel",
  "bonferroni", "BH", "BY", "none"))
}
\arguments{
\item{z}{Vector for the analysis.}

\item{con}{An object of class listw or a weight square matrix, giving
the weights for the analysis.}

\item{zerocon}{If zerocon = 0 the program assigns the value 0 to those individuals
with non null connections; if zerocon = NA the program assigns NA.}

\item{classG}{Class of statistics, could be G (default) or G*.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{test}{If test = "bootstrap", the program generates a bootstrap resampling and the
associated confidence intervals of the null hypothesis; if test = "permutation"
(default), a permutation test is made and the p value is calculated.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the hypothesis by difference between the median of the simulations
and the observed value. Other options are: "two.sided", "greater" and "less".}

\item{adjust}{Correction method passed to \code{\link[stats]{p.adjust}}.
Default is "fdr".}
}
\description{
This program computes the Local Getis-Ord G and G* statistic for
the data z, with p values or a confidence interval for the null hypothesis.
}
\examples{
\dontrun{
data(eco.test)
require(adegenet)
con<-chooseCN(eco$XY, type = 1, result.type = "listw", plot.nb = FALSE)
eco.getisord(eco$P[, 3], con, nsim = 99,
test = "permutation", classG = "G")
getis <- eco.getisord(eco$P[, 3], con, nsim = 99, classG = "G*")
eco.rankplot(getis, eco$XY)
getis <- eco.getisord(eco$P[, 3], con, nsim = 99, classG = "G*",
test = "bootstrap")
eco.forestplot(getis)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

