% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setSelectOnGametes}
\alias{setSelectOnGametes}
\title{Setting the selection on gametes}
\usage{
setSelectOnGametes(
  genomeObj = NULL,
  gamFit = c(),
  femaleFit = c(),
  maleFit = c(),
  selectionObj = NULL
)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}

\item{gamFit}{an haplotypic fitness vector for all individuals}

\item{femaleFit}{an haplotypic fitness vector for females only}

\item{maleFit}{an haplotypic fitness vector for males only}

\item{selectionObj}{a \code{Selection} object (in the case where the
selection on individuals is overlaid on an existing \code{Selection} object)}
}
\value{
a \code{Selection} object
}
\description{
Generation of an object of the \code{Selection} class which defines a
selection among the individuals either by adding this type of selection
to an already existing \code{SelectionObj} object (parameter
\code{selectionObj}) or by creating one.
}
\examples{
DL <- list(dl = c("A", "a"))
HL <- list(hl = c("B", "b"))
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = DL)
selectionObj <- setSelectOnGametes(
  genomeObj = genomeObj,
  gamFit = c(1, 1, 0.5, 0)
)

}
\author{
Ehouarn Le Faou
}
