% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{esgdiscountfactor}
\alias{esgdiscountfactor}
\title{Stochastic discount factors or discounted values}
\usage{
esgdiscountfactor(r, X)
}
\arguments{
\item{r}{the short rate, a \code{numeric} (constant rate) or a time series object}

\item{X}{the asset's price, a \code{numeric} (constant payoff or asset price) or a time series 
object}
}
\description{
This function provides calculation of stochastic discount factors 
or discounted values
}
\details{
The function result is : 

\deqn{X_t exp(-\int_0^t r_s ds)}

where \eqn{X_t} is an asset value at a given maturity \eqn{t}, and 
\eqn{(r_s)_s} is the risk-free rate.
}
\examples{

kappa <- 1.5
V0 <- theta <- 0.04
sigma_v <- 0.2
theta1 <- kappa*theta
theta2 <- kappa
theta3 <- sigma_v

# OU
r <- simdiff(n = 10, horizon = 5, 
               frequency = "quart",  
               model = "OU", 
               x0 = V0, theta1 = theta1, theta2 = theta2, theta3 = theta3)

# Stochastic discount factors
esgdiscountfactor(r, 1)
}
\seealso{
\code{\link{esgmcprices}}, \code{\link{esgmccv}}
}
\author{
Thierry Moudiki
}
