% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{exploreReg}
\alias{exploreReg}
\title{A function to launch the Exploratory Regression Shiny App}
\usage{
exploreReg(ERmfull, ERdata = NULL, ERbarcols = RColorBrewer::brewer.pal(4,
  "Set2"), npcpCols = 4, pvalOrder = F)
}
\arguments{
\item{ERmfull}{the lm fit to be explored}

\item{ERdata}{the data used to fit the model. If NULL, attempts to extract from ERmfull.}

\item{ERbarcols}{a vector of colours, one per term in lm.
Will be expanded via colorRampPalette if not the correct length.}

\item{npcpCols}{number of colours for the PCP}

\item{pvalOrder}{if TRUE, re-arranges predictors in order of p-value}
}
\value{
the shiny server
}
\description{
A function to launch the Exploratory Regression Shiny App
}
\examples{
f <- lm(mpg ~ hp+wt+disp, data=mtcars)
\dontrun{exploreReg(f)}

}
