% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e.interaction.plot.R
\name{e.interaction.plot}
\alias{e.interaction.plot}
\title{plot interaction effect of two exposures}
\usage{
e.interaction.plot(fit, data, exp_1, exp_2)
}
\arguments{
\item{fit}{Fitted model from function 'plsi.lr.v1'}

\item{data}{Original data set}

\item{exp_1}{exposure name hoping to be checked}

\item{exp_2}{exposure name hoping to be checked}
}
\value{
plot of interaction effect of two exposures with others at average level
}
\description{
plot interaction effect of two exposures
}
\examples{
\donttest{
# example to plot interaction effect of two exposures
data(nhanes.new)
dat <- nhanes.new

# specify variable names and parameters
Y.name <- "log.triglyceride"
X.name <- c("X1_trans.b.carotene", "X2_retinol", "X3_g.tocopherol", "X4_a.tocopherol",
            "X5_PCB99", "X6_PCB156", "X7_PCB206",
            "X8_3.3.4.4.5.pncb", "X9_1.2.3.4.7.8.hxcdf", "X10_2.3.4.6.7.8.hxcdf")
Z.name <- c("AGE.c", "SEX.Female", "RACE.NH.Black",
           "RACE.MexicanAmerican", "RACE.OtherRace", "RACE.Hispanic" )
spline.num = 5
spline.degree = 3
initial.random.num = 1

# run PLSI linear regression
set.seed(2023)
model_1 <- plsi.lr.v1(data = dat, Y.name = Y.name, X.name = X.name, Z.name = Z.name,
                      spline.num, spline.degree, initial.random.num)

# plot two exposures' interaction effect
e.interaction.plot(model_1, dat, "X4_a.tocopherol", "X3_g.tocopherol")
e.interaction.plot(model_1, dat, "X4_a.tocopherol", "X10_2.3.4.6.7.8.hxcdf")

# exchange exposures' names
e.interaction.plot(model_1, dat, "X8_3.3.4.4.5.pncb", "X6_PCB156")
e.interaction.plot(model_1, dat, "X6_PCB156", "X8_3.3.4.4.5.pncb")
}
}
\author{
Yuyan Wang
}
\keyword{exposures.interaction.effect}
