% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{ENMevaluation-class}
\alias{ENMevaluation-class}
\alias{ENMevaluation}
\alias{show,ENMevaluation-method}
\title{ENMevaluation class}
\usage{
\S4method{show}{ENMevaluation}(object)
}
\arguments{
\item{object}{ENMevaluation object}
}
\description{
An S4 class that contains the ENMevaluate results.
}
\details{
The following are brief descriptions of the columns in the results table, which prints
when accessing `e@results` or `results(e)` if `e` is the ENMevaluation object. Those columns
that represent evaluations of validation data (__.val.__) end in either "avg" (average of the
metric across the models trained on withheld data during cross-validation) or "sd" (standard
deviation of the metric across these models).\cr*
fc = feature class\cr*
rm = regularization multiplier\cr*
tune.args = combination of arguments that define the complexity settings used for tuning (i.e., fc and rm for Maxent)\cr*
auc.train = AUC calculated on the full dataset\cr*
cbi.train = Continuous Boyce Index calculated on the full dataset\cr*
auc.val = average/sd AUC calculated on the validation datasets (the data withheld during cross-validation)\cr*
auc.diff = average/sd difference between auc.train and auc.val\cr*
or.mtp = average/sd omission rate with threshold as the minimum suitability value across occurrence records\cr*
or.10p = average/sd omission rate with threshold as the minimum suitability value across occurrence records after removing the lowest 10%\cr*
cbi.val = average/sd Continuous Boyce Index calculated on the validation datasets (the data withheld during cross-validation)\cr*
AICc = AIC corrected for small sample sizes\cr*
delta.AICc = highest AICc value across all models minus this model's AICc value, where lower values mean higher performance and 0 is the highest performing model\cr*
w.AIC = AIC weights, calculated by exp( -0.5 * delta.AIC), where higher values mean higher performance\cr*
ncoef = number of non-zero beta values (model coefficients)
}
\section{Slots}{

\describe{
\item{\code{algorithm}}{character: algorithm used}

\item{\code{tune.settings}}{data frame: settings that were tuned}

\item{\code{partition.method}}{character: partition method used}

\item{\code{partition.settings}}{list: partition settings used (i.e., value of *k* or aggregation factor)}

\item{\code{other.settings}}{list: other modeling settings used (i.e., decisions about clamping, AUC diff calculation)}

\item{\code{doClamp}}{logical: whether or not clamping was used}

\item{\code{clamp.directions}}{list: the clamping directions specified}

\item{\code{results}}{data frame: evaluation summary statistics}

\item{\code{results.partitions}}{data frame: evaluation k-fold statistics}

\item{\code{models}}{list: model objects}

\item{\code{variable.importance}}{list: variable importance data frames (when available)}

\item{\code{predictions}}{RasterStack: model predictions}

\item{\code{taxon.name}}{character: the name of the focal taxon (optional)}

\item{\code{occs}}{data frame: occurrence coordinates and predictor variable values used for model training}

\item{\code{occs.testing}}{data frame: when provided, the coordinates of the fully-withheld testing records}

\item{\code{occs.grp}}{vector: partition groups for occurrence points}

\item{\code{bg}}{data frame: background coordinates and predictor variable values used for model training}

\item{\code{bg.grp}}{vector: partition groups for background points}

\item{\code{overlap}}{list: matrices of pairwise niche overlap statistics}

\item{\code{rmm}}{list: the rangeModelMetadata objects for each model}
}}

\references{
For references on performance metrics, see the following:

In general for ENMeval: 

Muscarella, R., Galante, P. J., Soley-Guardia, M., Boria, R. A., Kass, J. M., Uriarte, M., & Anderson, R. P. (2014). ENMeval: An R package for conducting spatially independent evaluations and estimating optimal model complexity for Maxent ecological niche models. \emph{Methods in Ecology and Evolution}, \bold{5}: 1198-1205. \doi{10.1111/2041-210X.12261}

\emph{AUC}

Fielding, A. H., & Bell, J. F. (1997). A review of methods for the assessment of prediction errors in conservation presence/absence models. \emph{Environmental Conservation}, \bold{24}: 38-49. \doi{10.1017/S0376892997000088}

Jiménez‐Valverde, A. (2012). Insights into the area under the receiver operating characteristic curve (AUC) as a discrimination measure in species distribution modelling. \emph{Global Ecology and Biogeography}, \bold{21}: 498-507. \doi{10.1111/j.1466-8238.2011.00683.x}

\emph{AUC diff}

Warren, D. L., Glor, R. E., Turelli, M. & Funk, D. (2008) Environmental niche equivalency versus conservatism: quantitative approaches to niche evolution. \emph{Evolution}, \bold{62}: 2868-2883. \doi{10.1111/j.1558-5646.2008.00482.x}

Radosavljevic, A., & Anderson, R. P. (2014). Making better Maxent models of species distributions: complexity, overfitting and evaluation. \emph{Journal of Biogeography}, \bold{41}(4), 629-643. \doi{10.1111/jbi.12227} 

\emph{Omission rates}

Radosavljevic, A., & Anderson, R. P. (2014). Making better Maxent models of species distributions: complexity, overfitting and evaluation. \emph{Journal of Biogeography}, \bold{41}(4), 629-643. \doi{10.1111/jbi.12227}

\emph{Continuous Boyce Index}

Hirzel, A. H., Le Lay, G., Helfer, V., Randin, C., & Guisan, A. (2006). Evaluating the ability of habitat suitability models to predict species presences. \emph{Ecological Modelling}, \bold{199}: 142-152. \doi{10.1016/j.ecolmodel.2006.05.017}
}
\author{
Jamie M. Kass, \email{jamie.m.kass@gmail.com}, Bob Muscarella, \email{bob.muscarella@gmail.com}
}
