% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSE.R
\name{Execute_SCSE}
\alias{Execute_SCSE}
\title{SCSE methods to calculate EMT score}
\usage{
Execute_SCSE(geneExp, geneList, colnames)
}
\arguments{
\item{geneExp}{A numeric matrix of gene expression values, where rows represent genes and columns represent samples/cells.}

\item{geneList}{A list of signature gene sets, with each element containing gene names for the respective signature.}

\item{colnames}{A character string representing the name to assign to the column containing the EMT scores in the output data frame.}
}
\value{
A data frame containing sample/cell ID and their respective EMT scores.
}
\description{
SCSE methods to calculate EMT score
}
\examples{
library(curl)
url <- "https://zenodo.org/record/15213845/files/geneExp.rda"
destfile <- tempfile(fileext = ".rda")
download.file(url, destfile, mode = "wb")
load(destfile)
data(Panchy_et_al_E_signature)
Execute_SCSE(geneExp, geneList = Panchy_et_al_E_signature,colnames = "Escore")
}
