% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSS.R
\name{summary.EMSS}
\alias{summary.EMSS}
\alias{print.summary.EMSS}
\title{Summarizing EM type Sample Selection Model Fits}
\usage{
\method{summary}{EMSS}(object, ...)

\method{print}{summary.EMSS}(x, digits = max(3, getOption("digits") - 3),
  ...)
}
\arguments{
\item{object}{an object of class "EMSS" made by the function \code{EMSS}.}

\item{...}{not used, but exists because of the compatibility.}

\item{x}{an object of class "summary.EMSS".}

\item{digits}{a numeric number of significant digits.}
}
\description{
\code{summary} method for a class "EMSS".
}
\examples{
# examples continued from EMSS
data(Smoke, package = "EMSS")
ex1 <- EMSS(response = cigs_intervals ~ educ,
           selection = smoker ~ educ + age,
           data = Smoke)
summary(ex1)

data(Smoke, package = "EMSS")
ex2 <- EMSS(response = cigs_intervals ~ educ,
           selection =  smoker ~ educ + age,
           data = Smoke, method="ECMnr")
summary(ex2)

## example using random numbers with exclusion restriction

N <- 1000
errps <- mvtnorm::rmvnorm(N,c(0,0),matrix(c(1,0.5,0.5,1),2,2) )
xs <- runif(N)
ys <- xs+errps[,1]>0
xo <- runif(N)
yo <- (xo+errps[,2])*(ys>0)

ex3 <- EMSS(response = yo ~ xo,
           selection = ys ~ xs,
           initial.param = c(rep(0,4), 0.3, 0.6), method="ECMnr")
summary(ex3)

}
