% Generated by roxygen2 (4.0.2): do not edit by hand
\name{EMDomics}
\alias{EMDomics}
\title{Create an EMDomics object}
\usage{
EMDomics(data, samplesA, samplesB, emd, emd.perm)
}
\arguments{
\item{data}{A matrix containing genomics data (e.g. gene expression levels).
The rownames should contain gene identifiers, while the column names should
contain sample identifiers.}

\item{samplesA}{A vector of sample names identifying samples in \code{data}
that belong to "group A". The names must corresponding to column names
in \code{data}.}

\item{samplesB}{A vector of sample names identifying samples in \code{data}
that belong to "group B". The names must corresponding to column names
in \code{data}.}

\item{emd}{A matrix containing a row for each gene in \code{data}, and with
the following columns:
\itemize{
\item \code{emd} The calculated emd score.
\item \code{fc} The log2 fold change of "group A" samples relative to "group B"
samples.
\item \code{q-value} The calculated q-value.
}
The row names should specify the gene identifiers for each row.}

\item{emd.perm}{A matrix containing a row for each gene in \code{data}, and
with a column containing emd scores for each random permutation calculated
via \code{\link{calculate_emd}}.}
}
\value{
The function combines it's arguments in a list, which is assigned class
'EMDomics'. The resulting object is returned.
}
\description{
This is the constructor for objects of class 'EMDomics'. It
is used in \code{\link{calculate_emd}} to construct the return value.
}
\seealso{
\code{\link{calculate_emd}}
}

