% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMAS.volcano.R
\name{EMAS.volcano}
\alias{EMAS.volcano}
\title{Plotting the volcano plot from the EMAS results}
\usage{
EMAS.volcano(
  E.result,
  epiwideline = -log10(1e-07),
  suggestiveline = -log10(1e-05)
)
}
\arguments{
\item{E.result}{A data.frame produced by \code{Emas}.}

\item{epiwideline}{Where to draw a "epigenome-wide sigificant" line. Default -log10(1.0e-7).}

\item{suggestiveline}{Where to draw a "suggestive" line. Default -log10(1.0e-5). Set to FALSE to disable.}
}
\value{
No return value, called for side effects.
}
\description{
Function to plot a volcano plot from the \code{Emas} results.
}
\details{
This function can plot a volcano plot from the \code{Emas} results.
}
\examples{
\donttest{data(E.result)
EMAS.volcano(E.result, 
             epiwideline = -log10(0.05/2000),
             suggestiveline = -log10(1/100))}
}
\author{
Xiuquan Nie, niexiuquan1995@foxmail.com
}
