% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMAS.manhattan.R
\name{EMAS.manhattan}
\alias{EMAS.manhattan}
\title{Plotting the manhattan plot from the EMAS results}
\usage{
EMAS.manhattan(x, type = "EPIC", ...)
}
\arguments{
\item{x}{A data.frame produced by \code{Emas}.}

\item{type}{A character string indicating the type of annotation, only "EPIC" and "450k" are available.}

\item{...}{Other arguments passed to \code{manhattan}.}
}
\value{
No return value, called for side effects.
}
\description{
Function to plot a manhattan plot from the \code{Emas} results.
}
\details{
This function can plot a manhattan plot from the \code{Emas} results according to the annotation from 450k or EPIC.
}
\examples{
\donttest{data(E.result)
EMAS.manhattan(E.result, type = "EPIC",
               genomewideline = -log10(0.05/2000),
               suggestiveline = -log10(1/100), ylim=c(0,5))}
}
\references{
Turner, (2018). qqman: an R package for visualizing GWAS results using Q-Q and manhattan plots.
\emph{Journal of Open Source Software}, 3(25), 731. \doi{doi:10.21105/joss.00731}.
}
\author{
Xiuquan Nie, niexiuquan1995@foxmail.com
}
